VERSION 5.00
Begin VB.UserControl SPA_Admin_MKT 
   ClientHeight    =   9705
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   15255
   ScaleHeight     =   9705
   ScaleWidth      =   15255
   Begin VB.Frame fra_Detail 
      Height          =   7455
      Left            =   0
      TabIndex        =   1
      Tag             =   "fra_Detail"
      Top             =   720
      Width           =   13425
      Begin Project1.ArmGrid grd_Active 
         Height          =   3615
         Left            =   3360
         TabIndex        =   22
         Tag             =   "grd_ValidRules"
         Top             =   1440
         Width           =   7695
         _ExtentX        =   13573
         _ExtentY        =   6376
      End
      Begin VB.CheckBox chk_ObvioustAuth_Flag 
         Alignment       =   1  'Right Justify
         Caption         =   "#Obvious flag"
         Height          =   255
         Left            =   3135
         TabIndex        =   5
         Tag             =   "chk_ObvioustAuth_Flag"
         Top             =   1050
         Width           =   2415
      End
      Begin Project1.ArmCheckView ckv_Countries 
         Height          =   3735
         Left            =   120
         TabIndex        =   6
         Top             =   1440
         Width           =   3135
         _ExtentX        =   5530
         _ExtentY        =   6588
      End
      Begin VB.CheckBox chk_FullAuth 
         Alignment       =   1  'Right Justify
         Caption         =   "#Full authorization"
         Height          =   255
         Left            =   120
         TabIndex        =   4
         Tag             =   "chk_FullAuth"
         Top             =   1080
         Width           =   2415
      End
      Begin VB.TextBox txt_Key 
         Height          =   330
         Left            =   11505
         TabIndex        =   19
         Top             =   180
         Visible         =   0   'False
         Width           =   1785
      End
      Begin VB.Frame fra_manipulation 
         Caption         =   "#Manipulation"
         Height          =   1590
         Left            =   120
         TabIndex        =   7
         Tag             =   "frm_maintenance"
         Top             =   5280
         Width           =   6570
         Begin VB.TextBox txt_Date 
            Alignment       =   2  'Center
            Enabled         =   0   'False
            Height          =   330
            Left            =   1740
            TabIndex        =   13
            Tag             =   "txt_Date"
            Text            =   "02/02/2001"
            Top             =   322
            Width           =   1095
         End
         Begin VB.TextBox txt_creator 
            Enabled         =   0   'False
            Height          =   330
            Left            =   3870
            TabIndex        =   12
            Tag             =   "txt_creator"
            Text            =   "L. Cockayne"
            Top             =   322
            Width           =   2415
         End
         Begin VB.TextBox txt_lastUpd 
            Alignment       =   2  'Center
            Enabled         =   0   'False
            Height          =   330
            Left            =   1740
            TabIndex        =   11
            Tag             =   "txt_lastUpd"
            Text            =   "02/02/2001"
            Top             =   742
            Width           =   1095
         End
         Begin VB.TextBox txt_updUser 
            Enabled         =   0   'False
            Height          =   330
            Left            =   3870
            TabIndex        =   10
            Tag             =   "txt_updUser"
            Text            =   "L. Cockayne"
            Top             =   742
            Width           =   2415
         End
         Begin VB.TextBox txt_dropDate 
            Alignment       =   2  'Center
            Enabled         =   0   'False
            Height          =   330
            Left            =   1740
            TabIndex        =   9
            Tag             =   "txt_dropDate"
            Text            =   "02/02/2001"
            Top             =   1132
            Width           =   1095
         End
         Begin VB.CheckBox chk_dropped 
            Caption         =   "#Dropped"
            Height          =   255
            Left            =   3870
            TabIndex        =   8
            Tag             =   "chk_dropped"
            Top             =   1170
            Width           =   1515
         End
         Begin VB.Label lbl_label 
            Caption         =   "#Creation date"
            Height          =   255
            Index           =   2
            Left            =   150
            TabIndex        =   18
            Tag             =   "lbl_date"
            Top             =   360
            Width           =   1530
         End
         Begin VB.Label lbl_label 
            Caption         =   "#By"
            Height          =   255
            Index           =   3
            Left            =   3150
            TabIndex        =   17
            Tag             =   "lbl_ByUser"
            Top             =   360
            Width           =   690
         End
         Begin VB.Label lbl_label 
            Caption         =   "#Last updade"
            Height          =   255
            Index           =   4
            Left            =   150
            TabIndex        =   16
            Tag             =   "lbl_dateUpd"
            Top             =   780
            Width           =   1530
         End
         Begin VB.Label lbl_label 
            Caption         =   "#By"
            Height          =   255
            Index           =   5
            Left            =   3150
            TabIndex        =   15
            Tag             =   "lbl_creator"
            Top             =   720
            Width           =   690
         End
         Begin VB.Label lbl_label 
            Caption         =   "#Drop date"
            Height          =   255
            Index           =   6
            Left            =   150
            TabIndex        =   14
            Tag             =   "lbl_dropDate"
            Top             =   1170
            Width           =   1530
         End
      End
      Begin VB.TextBox txt_SPM_Desc 
         Height          =   330
         Left            =   2280
         MaxLength       =   80
         TabIndex        =   2
         Text            =   "SPM_Desc"
         Top             =   240
         Width           =   8895
      End
      Begin VB.TextBox txt_SPM_SDesc 
         Height          =   330
         Left            =   2280
         MaxLength       =   10
         TabIndex        =   3
         Text            =   "SPM_SDesc"
         Top             =   600
         Width           =   8895
      End
      Begin VB.Label lbl_label 
         Caption         =   "#Description"
         Height          =   240
         Index           =   0
         Left            =   90
         TabIndex        =   21
         Tag             =   "lbl_Description"
         Top             =   315
         Width           =   2145
      End
      Begin VB.Label lbl_label 
         Caption         =   "#Short Description"
         Height          =   240
         Index           =   1
         Left            =   90
         TabIndex        =   20
         Tag             =   "lbl_ShortDescription"
         Top             =   675
         Width           =   2145
      End
   End
   Begin Project1.ToolbarControl tlb_main 
      Height          =   690
      Left            =   15
      TabIndex        =   0
      Top             =   0
      Width           =   6885
      _ExtentX        =   12144
      _ExtentY        =   1217
   End
End
Attribute VB_Name = "SPA_Admin_MKT"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

' **************************************************************************************************
' ************************************* EXTERNAL DECLARATIONS **************************************
' **************************************************************************************************
Private Declare Function GetTempPath Lib "kernel32" Alias "GetTempPathA" (ByVal nBufferLength As Long, ByVal lpBuffer As String) As Long
Private Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
Private Declare Function GetLocaleInfo Lib "kernel32" Alias "GetLocaleInfoA" (ByVal Locale As Long, ByVal LCType As Long, ByVal lpLCData As String, ByVal cchData As Long) As Long
Private Declare Function LockWindowUpdate Lib "user32" (ByVal hwnd As Long) As Long
' **************************************************************************************************

' **************************************************************************************************
' **************************************** TOOL CONSTANTS ******************************************
' **************************************************************************************************
Private Const LOCALE_USER_DEFAULT = &H400
Private Const LOCALE_SDECIMAL = &HE ' Decimal separator
Private Const LOCALE_STHOUSAND = &HF ' Thousand separator
Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SEP As String = SEP1 + SEP2
Private Const C_APPNAME As String = "SPA_MKT"                ' for error log
Private Const C_SCREENNAME As String = "SPA_Admin_MKT"     ' for loading screen constants
Private Const C_SCREENMODE_STACK_SIZE As Long = 5           ' size of stack for active screens
Private Const C_TOOLBARFACE_ITEM_VIEW As String = "0"
Private Const C_TOOLBARFACE_ITEM_ADD As String = "1"
Private Const C_TOOLBARFACE_ITEM_UPD As String = "2"
Private Const C_TOOLBARFACE_ITEM_DEL As String = "3"
Private Const SIFYB_CM_ERROR_MESSAGE = 2400                 ' const for base of error messages ids
Private Const C_ID_KEY = "SPA_MKT"                           ' A_ID entry for new record
Private Const C_ID_KEY_AUTH_COUNTRIES = "SPA_AuthCountries"   ' A_ID entry for new record
' ****************************************** TOOL CONSTANTS ***************************************

' **************************************************************************************************
' **************************************** USER DEFINED ERRORS *************************************
' **************************************************************************************************
Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    CompFncFailed = vbObjectError + 6           ' when component function fail
    QuietException = vbObjectError + 7          ' do not display error message
    WarMsgSelectRow = vbObjectError + 8
    SQLBadRowAffectedCount = vbObjectError + 9  ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 10 ' A SQL request does not return the expected rowcount : select an item return nothing...
End Enum

Private Enum ErrMsg
    ErrMsgNone = 0
    ErrMsgMandatoryAreEmpty = SIFYB_CM_ERROR_MESSAGE + 1
    ErrMsgDuplicateOrder = SIFYB_CM_ERROR_MESSAGE + 2
    ErrMsgDuplicateLevel = SIFYB_CM_ERROR_MESSAGE + 3
    ErrMsgMissingLevel = SIFYB_CM_ERROR_MESSAGE + 4
    ErrMsgNumericRequired = SIFYB_CM_ERROR_MESSAGE + 5
    ErrMsgItemIsDeleted = SIFYB_CM_ERROR_MESSAGE + 19
    ErrMsgPlanNotSelected = SIFYB_CM_ERROR_MESSAGE + 20
    ErrMsgItemAlreadyInGrid = SIFYB_CM_ERROR_MESSAGE + 21
    ErrMsgActionInProgress = SIFYB_CM_ERROR_MESSAGE + 22
    ErrMsgActionIsCompleted = SIFYB_CM_ERROR_MESSAGE + 23
    QueMsgActionIsCompleted = SIFYB_CM_ERROR_MESSAGE + 24
    ErrMsgVendorNotSelected = SIFYB_CM_ERROR_MESSAGE + 25
    QueMsgUpdateCompletedTask = SIFYB_CM_ERROR_MESSAGE + 26
    ErrMsgUpdateDeletedTask = SIFYB_CM_ERROR_MESSAGE + 27
End Enum

' *************************************** USER DEFINED ERRORS **************************************

' **************************************************************************************************
' *************************************** CONTROL MEMBERS ******************************************
' **************************************************************************************************
Dim ml_U_Code As Long                   ' if this is user loging app, needed to log errors into A_Log
Dim ms_LoginName As String
Dim ms_Language_Code As String
Dim mb_Initialized As Boolean           ' True if the component is already initialized
Dim mb_Initializing As Boolean          ' Flag of initializing
Dim mua_ActiveMode() As ArmScreenMode
Dim ms_Title As String                  ' title of user control - can be assigned as Caption to the parent form or title for printing
Dim ml_iConcurrency As Long             ' iconc of the record curently loaded
Dim ms_DecimalSeparator As String       ' decimal separator obtained from local settings
Dim ms_ThousandSeparator As String      'locale thousand separator

Dim moa_ListFieldsMandatory As Variant  ' all mandatory controls
Dim moa_ListFieldsNumeric As Variant    ' all numeric controls
Dim moa_ListFieldsToDisable() As Control            ' common disabled control


Private Enum ArmScreenMode
    smRefreshOnly
    smMain
    smAdd
    smUpdate
    smDelete
    smView
    smAddItem
    smUpdateItem
    smDeleteItem
    smViewItem
End Enum

#If LIVE = 1 Then
    Dim mo_Db As Object
#Else
    Dim mo_Db As ARMSYSCOMLib.ArmDb
#End If

#If LIVE = 1 Then
    Dim mo_FSO As Object
#Else
    Dim mo_FSO As Scripting.FileSystemObject
#End If

Dim ma_AuthCountries_ID_LIST()   As Long
Dim ms_ErrMessage                As String
Dim ms_ServerDate                As Date

Private mo_tokenManager       As ArmToken

' *************************************** CONTROL MEMBERS ******************************************
Public Event OnExit()
Public Event OnItemAdd(ByVal av_Key As Variant, ByVal as_SrzFields As String)
Public Event OnItemUpdate(ByVal av_Key As Variant, ByVal as_SrzFields As String)
Public Event OnItemDelete(ByVal av_Key As Variant)
Public Event OnItemNext()
Public Event OnItemPrevious()
Public Event OnPrint(ByVal av_Key As Variant)


' **************************************************************************************************
' **************************************************************************************************
' **************************************************************************************************


' mb_Initialized is a read-only property, indicates the status of the component
Public Sub Move(ByVal aLeft As Single, ByVal aTop As Single, ByVal aWidth As Single, ByVal aHeight As Single)
    Call UserControl.Extender.Move(aLeft, aTop, aWidth, aHeight)
End Sub
Public Property Let Visible(ByVal aVisible As Boolean)
    UserControl.Extender.Visible = aVisible
End Property
Public Property Get Initialized() As Boolean
    Initialized = mb_Initialized
End Property
Public Sub Zorder()
  Call UserControl.Extender.Zorder
End Sub
Public Property Let U_Code(ByVal al_U_Code As Long)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    
    ml_U_Code = al_U_Code
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".U_Code(Let)")
End Property

Public Property Let LoginName(ByVal as_LoginName As String)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    
    ms_LoginName = as_LoginName
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".LoginName(Let)")
End Property

Public Property Let Language_Code(as_Language_Code As String)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    If Len(as_Language_Code) <> 1 Then Call Err.Raise(ArmErr.InvalidArgument, "", "Language_code must contains only 1 char")
    
    ms_Language_Code = as_Language_Code
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Language(Let)")
End Property

Public Property Set DB(ByRef ao_DB As ArmDb)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    If ao_DB Is Nothing Then Call Err.Raise(ArmErr.InvalidArgument)
    
    Set mo_Db = ao_DB
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Db(Set)")
End Property

Public Property Get Title() As String
    Title = ms_Title
End Property

Public Sub Run(ByVal ae_ScrMode As SPA_Mode, ByVal av_Key As Variant)
On Error GoTo ErrHandler

    Debug.Assert (mb_Initialized = True)
    
    Call LockScreen(True)       'JN: i am not sure if this is necessary if called from other control which already locked the screen
    
    Select Case ae_ScrMode
        Case SPA_Mode.emView
            Call Item_ViewInit(av_Key)
        Case SPA_Mode.emAdd
            Call Item_AddInit
        Case SPA_Mode.emUpdate
            Call Item_UpdateInit(av_Key)
        Case SPA_Mode.emDelete
            Call Item_DeleteInit(av_Key)
            
    End Select
    
    Call LockScreen(False)
    
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage(Extender.Name & ".Run")
End Sub

Public Sub Load_A_COM()
Dim lo_Control As Object
On Error GoTo ErrHandler
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    If mo_Db Is Nothing Then Call Err.Raise(ArmErr.PropertyNotSet, "", "mo_Db")
    If Len(ms_Language_Code) < 1 Then Call Err.Raise(ArmErr.PropertyNotSet, "", "ms_Language_Code")
    
    ' get decimal separator for conversion from string to double
    ms_DecimalSeparator = Format(0, ".")
    Dim sBuffer As String
    Dim nBufferLen As Long
    nBufferLen = 255
    sBuffer = String$(nBufferLen, vbNullChar)
    nBufferLen = GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_STHOUSAND, sBuffer, nBufferLen)
    If nBufferLen > 0 Then
        ms_ThousandSeparator = Left$(sBuffer, nBufferLen - 1)
    End If

    ' init token manager
    Set mo_tokenManager = New ArmToken
    Set mo_tokenManager.DB = mo_Db
    Call mo_tokenManager.Load_A_COM

    ' Set Db
    ' Call Load_A_Com
    ' Initialize toolbars
    Debug.Assert (Not mo_Db Is Nothing)
    
    For Each lo_Control In UserControl.Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_COM
        Case "ARMPICKER"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_COM
            lo_Control.Locked = True
        Case "TOOLBARCONTROL"
            lo_Control.Language = ms_Language_Code
            lo_Control.HideTips = True
            lo_Control.Load_A_COM
        Case "ARMGRID"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_COM
        Case "ARMTREEVIEW"
            Set lo_Control.ArmDb = mo_Db
            lo_Control.Language = ms_Language_Code
            Call lo_Control.Load_A_COM
        Case "ARMCHECKVIEW"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_COM
        Case "A_CALOCX"
            lo_Control.Language = ms_Language_Code
            Call lo_Control.reinit_cal
        End Select
    Next
    
    Set mo_FSO = CreateObject("Scripting.FileSystemObject")
    
    ReDim Preserve mua_ActiveMode(0)
    mua_ActiveMode(UBound(mua_ActiveMode)) = ArmScreenMode.smMain

    ' init controls
    
    ReDim moa_ListFieldsMandatory(0 To 1) As Variant
    moa_ListFieldsMandatory(0) = Array(txt_SPM_Desc, 0)
    moa_ListFieldsMandatory(1) = Array(txt_SPM_SDesc, 1)
    
    'ReDim moa_ListFieldsNumeric(-1 To -1) As Variant
    
    Call InitMandatoryLabels(moa_ListFieldsMandatory)

    Call FillControlArray(moa_ListFieldsToDisable, Array(txt_Key, txt_Date, txt_creator, txt_lastUpd, txt_updUser, txt_dropDate, chk_dropped))
    
    Call InitComponents
    
    Call LoadLabels(UserControl.Controls, C_SCREENNAME, ms_Language_Code)
    Call ChangeCharset(UserControl.Controls, GetCodePageFromLanguage(mo_Db, ms_Language_Code))
    
    Call Components_Settings
    
    ' set layout
    Call InitCtrlSize
    
    mb_Initialized = True

    ' display starting face
    Call UpdateUI(ArmScreenMode.smMain)
    
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".Load_A_Com()")
End Sub

Private Sub FillControlArray(ByRef ao_ctrlArray() As Control, ByRef ao_array As Variant)
On Error GoTo ErrHandler
    Dim ll_i As Long
    If Not IsArray(ao_array) Then
        Exit Sub
    End If
    
    ReDim ao_ctrlArray(LBound(ao_array) To UBound(ao_array)) As Control
    
    For ll_i = LBound(ao_array) To UBound(ao_array)
        Set ao_ctrlArray(ll_i) = ao_array(ll_i)
    Next

    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".FillControlArray()")
End Sub

Public Sub Unload_A_COM()
Dim lo_Control As Object
On Error GoTo ErrHandler
    If Not Initialized Then Call Err.Raise(ArmErr.CPTNotInitialized)
    
    For Each lo_Control In UserControl.Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX", "TOOLBARCONTROL", "ARMGRID", "ARMTREEVIEW", "ARMCHECKVIEW", "ARMPICKER", "SRM_TASKPRODUCT", "SRM_ACTION", "SRM_ATTACHMENT"
            Call lo_Control.Unload_A_COM
        End Select
    Next
    
    Call mo_tokenManager.Unload_A_COM

    Set mo_Db = Nothing
    Set mo_FSO = Nothing
    Set mo_tokenManager = Nothing

    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".Unload_A_Com()")
End Sub

Private Sub Components_Settings()
On Error GoTo ErrHandler

    Call Component_SetUp(txt_Key, "SPM_Code" & SEP & "Num")
    
    Call Component_SetUp(txt_SPM_Desc, "SPM_Desc" & SEP & "Text")
    Call Component_SetUp(txt_SPM_SDesc, "SPM_SDesc" & SEP & "Text")
    Call Component_SetUp(chk_FullAuth, "FullAuth_Flag")
    Call Component_SetUp(chk_ObvioustAuth_Flag, "ObvioustAuth_Flag")
    
    ' system controls
    Call Component_SetUp(txt_Date, "Z_Creation" & SEP & "Date")
    Call Component_SetUp(txt_lastUpd, "Z_Last_Upd" & SEP & "Date")
    Call Component_SetUp(txt_dropDate, "Drop_Date" & SEP & "Date")
    Call Component_SetUp(txt_creator, "Z_Creator_Name" & SEP & "Text")
    Call Component_SetUp(txt_updUser, "Z_Last_Upd_User_Name" & SEP & "Text")
    Call Component_SetUp(chk_dropped, "Drop_flag")
    
    Exit Sub
    
ErrHandler:
    Call ErrorHandler("Components_Settings")
End Sub

Private Sub Component_SetUp(ByVal ao_cpt As Object, ByVal as_Tag As String)

On Error GoTo ErrHandler
    
    ao_cpt.Tag = as_Tag
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("Component_SetUp")
End Sub

Private Sub UpdateUI(Optional ByVal au_Mode As ArmScreenMode = ArmScreenMode.smRefreshOnly)
On Error GoTo ErrHandler

    ' set active face
    If au_Mode <> smRefreshOnly Then
        Call pushScreenMode(au_Mode)
    End If

    tlb_Main.Redraw = False

    ' hide all frames
    fra_detail.Visible = False
    tlb_Main.Visible = False

    ' we have clean screen we can display proper controls
    Select Case activeScreenMode
        Case smMain
        Case smAdd
            fra_detail.Visible = True
            tlb_Main.Visible = True
            Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_ADD)
            Call ckv_Countries.SetVisibleList("EDIT")
        Case smUpdate
            fra_detail.Visible = True
            tlb_Main.Visible = True
            Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_UPD)
            Call ckv_Countries.SetVisibleList("EDIT")
        Case smView
            fra_detail.Visible = True
            tlb_Main.Visible = True
            Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_VIEW)
            Call ckv_Countries.SetVisibleList("MAIN")
        Case smDelete
            fra_detail.Visible = True
            tlb_Main.Visible = True
            Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_DEL)
            Call ckv_Countries.SetVisibleList("MAIN")
        Case Else
            Debug.Assert (False)
    End Select
    
    ' apply rights on toolbar
    Call UpdateMainToolbar
    
    tlb_Main.Redraw = True

    ' to display face immidiatelly
    UserControl.Refresh
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".UpdateUI()")
End Sub

' ************************************************************************************
' **************************** FRAMEWORK FUNCTIONS ***********************************
' ************************************************************************************
Private Sub pushScreenMode(ByVal au_Mode As ArmScreenMode)
On Error GoTo ErrHandler
    If UBound(mua_ActiveMode) = C_SCREENMODE_STACK_SIZE - 1 Then
        ' move array left
        Debug.Print ("Stack is too small. Increase C_SCREENMODE_STACK_SIZE constant please.")
        Dim ll_Index As Long
        For ll_Index = 1 To UBound(mua_ActiveMode)
            mua_ActiveMode(ll_Index - 1) = mua_ActiveMode(ll_Index)
        Next
    Else
        ' allocate one more item
        ReDim Preserve mua_ActiveMode(UBound(mua_ActiveMode) + 1)
    End If
    mua_ActiveMode(UBound(mua_ActiveMode)) = au_Mode
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".pushScreenMode")
End Sub

Private Property Get activeScreenMode(Optional ByVal al_fromTop As Long = 0) As ArmScreenMode
On Error GoTo ErrHandler
    Debug.Assert (IsArray(mua_ActiveMode))
    activeScreenMode = mua_ActiveMode(UBound(mua_ActiveMode) - al_fromTop)
    Exit Property
ErrHandler:
     Call ErrorHandler(Extender.Name & ".activeScreenMode(Get)")
End Property

Private Sub popScreenMode()
On Error GoTo ErrHandler
    Debug.Assert (UBound(mua_ActiveMode) >= 1)
    ReDim Preserve mua_ActiveMode(UBound(mua_ActiveMode) - 1)
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".popScreenMode")
End Sub

Private Sub popScreenModeUntil(ByVal ae_goTo As ArmScreenMode)
On Error GoTo ErrHandler
    While activeScreenMode <> ae_goTo
        Call popScreenMode
    Wend
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".popScreenModeUntil")
End Sub


Private Sub InitComponents()
Const CL_REQUEST_TB As String = "A_ToolbarDef_sel 1, 2422, 2820, $id$"

On Error GoTo ErrHandler
    Dim lo_ctrl As Object
    Dim ll_cursor As Long
    Dim ll_i As Long
    
    ' main toolbar
    ll_cursor = OpenSQLSafe(mo_Db, Replace(CL_REQUEST_TB, "$id$", "NULL"))
    If mo_Db.Find(ll_cursor, "id", TLB_SPA_MKT_MTNC_ID) >= 0 Then
        Call tlb_Main.SetToolbarInfoStringParameters(mo_Db.GetFields(ll_cursor, "info"), Left(mo_Db.GetFields(ll_cursor, "info"), 3))
    Else
        Call Err.Raise(ArmErr.InvalidArgument, "mo_Db.Find", "Toolbar id(" & TLB_SPA_MKT_MTNC_ID & ") not found in DB")
    End If
    
    Call mo_Db.Close(ll_cursor)
    ll_cursor = 0
        
    ' init markets check view
    ckv_Countries.Driven_By = "Market"
    ckv_Countries.Common_List_Load = True
    ckv_Countries.Type_Of_Key = tkDependant
    ckv_Countries.Calling_Key_Fields = "SPM_Code"
    ckv_Countries.Calling_Key_Values = ""
    ckv_Countries.Link_Key_Fields = "CT_Code"
    ckv_Countries.ComboVisible = False
    
    Dim lv_RoleList As Variant
    Dim ls_EditRequest As String
    
    ls_EditRequest = ReplaceCommonPlaceholders("exec SPA_Countries_Lst NULL,$Language_Code$")
    
    ckv_Countries.RoleCount = 2
    ReDim lv_RoleList(1)
    lv_RoleList(0) = Array("MAIN", _
                            "VIEW", _
                            "", _
                            "", _
                            "Main view", _
                            "CT_CodeCT_DescClosedDate", _
                            "CT_Desc", _
                            "2700", _
                            "CT_Code", _
                            "exec SPA_AuthCountries_lst $SPM_Code$, '" & ms_Language_Code & "'", _
                            "", _
                            "", _
                            True, _
                            2, _
                            False, _
                            True, _
                            0, _
                            0)
                            
    lv_RoleList(1) = Array("EDIT", _
                            "EDIT", _
                            "", _
                            "", _
                            "EDIT", _
                            "CT_CodeCT_DescClosedDate", _
                            "CT_Desc", _
                            "2700", _
                            "CT_Code", _
                            ls_EditRequest, _
                            "", _
                            "", _
                            False, _
                            2, _
                            False, _
                            True, _
                            0, _
                            0)
    If Not ckv_Countries.SetRoleList(lv_RoleList) Then
        Err.Raise CompFncFailed, "ckv_Countries.SetRoleList", "Setting CheckView parameters failed."
    End If
        
    ' update view when edit check list changed by user
    ckv_Countries.Synchronize_View = True

    
    grd_Active.AllowExcelExport = True
    grd_Active.ExportTitles = True
    
    Call grd_Active.SetColumns(Array( _
          Join(Array("CT_Code", 0, 1, "CT_Code", "", "String"), SEP) _
        , Join(Array("CT_Desc", 2000, 0, "CT_Desc", "#Country", "string", "", "Left"), SEP) _
        , Join(Array("VDate_Start", 1200, 0, "VDate_Start", "#Start date", "Date", "", "Left"), SEP) _
        , Join(Array("VDate_End", 1200, 0, "VDate_End", "#End date", "Date", "", "Left"), SEP) _
        , Join(Array("ManualInsert", 0, 0, "ManualInsert", "", "string", "", "Left"), SEP) _
        ))

    
    Exit Sub
ErrHandler:
    If ll_cursor <> 0 Then
        Call mo_Db.Close(ll_cursor)
        ll_cursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".InitComponents()")
End Sub

Private Sub InitMandatoryLabels(ByRef av_ListFieldsMandatory As Variant)
On Error GoTo ErrHandler

Dim ll_Index As Long
Dim lo_Label As Label

    For ll_Index = 0 To UBound(av_ListFieldsMandatory)
        If av_ListFieldsMandatory(ll_Index)(1) >= 0 Then
            Set lo_Label = lbl_Label(av_ListFieldsMandatory(ll_Index)(1))
            lo_Label.FontBold = True
        End If
    Next
    Exit Sub
ErrHandler:
    Call ErrorHandler("InitMandatoryLabels")
End Sub

Private Function ReplaceCommonPlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler

    as_Request = ReplacePlaceHolder(as_Request, "$language_code$", SQLStr(ms_Language_Code))
    as_Request = ReplacePlaceHolder(as_Request, "$Z_Creator$", SqlInt(ml_U_Code))
    as_Request = ReplacePlaceHolder(as_Request, "$U_Code$", SqlInt(ml_U_Code))
    as_Request = ReplacePlaceHolder(as_Request, "$Z_Last_Upd_User$", SqlInt(ml_U_Code))
    ReplaceCommonPlaceholders = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ReplaceCommonPlaceholders")
End Function

Private Function ReplacePlaceHolder(ByVal as_Request As String, ByVal as_PlaceHolder As String, ByVal as_DefaultValue As String) As String
On Error GoTo ErrHandler
    
    ReplacePlaceHolder = Replace(as_Request, as_PlaceHolder, as_DefaultValue, , , vbTextCompare)

    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ReplacePlaceholder")
End Function
Private Sub InitCtrlSize()
On Error GoTo ErrHandler
Const c_margin As Long = 60
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".InitCtrlSize()")
End Sub

Private Sub LoadDataToForm(ByVal ac_Cursor As Long, ByRef aControls As Variant, ByRef aContainer As Object)
On Error GoTo ErrHandler
   
    Dim lIdx As Long, lCount As Long
    Dim lControl As Control
    Dim lValues As Variant
    Dim ls_TempTag As String
    
        lCount = aControls.Count - 1
    
        For lIdx = 0 To lCount
            Set lControl = aControls.Item(lIdx)
            If HasContainer(lControl, aContainer) Then
                Select Case UCase(TypeName(lControl))
                    Case "TEXTBOX"
                            ls_TempTag = lControl.Tag & SEP
                            lValues = Split(ls_TempTag, SEP)
                            If mo_Db.GetFieldIndex(ac_Cursor, lValues(0)) >= 0 Then
                                Select Case lValues(1)
                                    Case "Text"
                                        lControl.Text = mo_Db.GetFields(ac_Cursor, lValues(0))
                                    Case "Num"
                                        lControl.Text = Replace(mo_Db.GetFields(ac_Cursor, lValues(0)), ms_DecimalSeparator, ".", , , vbTextCompare)
                                    Case "Date"
                                        If mo_Db.GetFields(ac_Cursor, lValues(0)) = 0 Then
                                            lControl.Text = ""
                                        Else
                                            lControl.Text = Format(mo_Db.GetFields(ac_Cursor, lValues(0)), "dd\/mm\/yyyy")
                                        End If
                                End Select
                            End If
                    
                    Case "ARMCOMBOBOX"
                        ls_TempTag = lControl.Tag & SEP
                        lValues = Split(ls_TempTag, SEP)
                        If mo_Db.GetFieldIndex(ac_Cursor, lValues(0)) >= 0 Then
                            If mo_Db.GetFields(ac_Cursor, lValues(0)) = 0 Or mo_Db.GetFields(ac_Cursor, lValues(0)) = "" Then
                                Set lControl.SelectedItem = Nothing
                            Else
                                If lControl.SearchItem(mo_Db.GetFields(ac_Cursor, lValues(0)), 0, 0, True) = False Then
                                    If lControl.AddItem(Array(mo_Db.GetFields(ac_Cursor, lValues(0)), mo_Db.GetFields(ac_Cursor, lValues(1))), True) Is Nothing Then
                                        Err.Raise 2222, "", ""
                                    End If
                                End If
                            End If
                        End If
                        
                    Case "OPTIONBUTTON"
                        lValues = Split(lControl.Tag, SEP)
                        If mo_Db.GetFieldIndex(ac_Cursor, lValues(0)) >= 0 Then
                            If UCase(lValues(2)) Like UCase(mo_Db.GetFields(ac_Cursor, lValues(0))) Then
                                lControl.Value = True
                            End If
                        End If
                        
                    Case "CHECKBOX"
                        If mo_Db.GetFieldIndex(ac_Cursor, lControl.Tag) >= 0 Then
                            If UCase(mo_Db.GetFields(ac_Cursor, lControl.Tag)) Like "X" Then
                                lControl.Value = vbChecked
                            Else
                                lControl.Value = vbUnchecked
                            End If
                        End If
                        
                    Case "A_CALOCX"
                        lControl.date_courte = mo_Db.GetFields(ac_Cursor, lControl.Tag)
                        
                    Case "LABEL", "FRAME", "DIRLISTBOX", "FILELISTBOX", "DRIVELISTBOX", "TOOLBARCONTROL", "COMMANDBUTTON", "ARMCHECKVIEW"
                        'Do Nothing
                    
                    Case "ARMGRID"
                        ' LOAD GRID
                    Case "ARMPICKER"
                        ls_TempTag = lControl.Tag & SEP
                        lValues = Split(ls_TempTag, SEP)
                        If mo_Db.GetFieldIndex(ac_Cursor, lValues(0)) >= 0 Then
                            lControl.ItemCode = mo_Db.GetFields(ac_Cursor, lValues(0))
                            lControl.ItemDescription = mo_Db.GetFields(ac_Cursor, lValues(1))
                            If lControl.ItemCode = "0" And lControl.ItemDescription = "" Then lControl.ItemCode = ""
                        End If
                    
                    Case Else
                        Debug.Print "LoadDataToForm  -> " & UCase(TypeName(lControl))
                End Select
            End If
            Set lControl = Nothing
        Next

    Exit Sub

ErrHandler:
    If Not lControl Is Nothing Then Set lControl = Nothing
    Call ErrorHandler("LoadDataToForm")

End Sub

' Load the labels of a containers
Private Sub LoadLabels(ByRef aControls As Variant, ByVal as_ScreenName As String, ByVal as_Language As String)

On Error GoTo ErrHandler

    Dim lIdx As Long, lCount As Long, lLabels As Long
    Dim lControl As Control
    
    lLabels = OpenSQLSafe(mo_Db, "exec Screen_Csts '" & as_ScreenName & "','" & as_Language & "'")
    Debug.Assert (lLabels <> 0)
    
    lCount = aControls.Count - 1
    
    For lIdx = 0 To lCount
        Set lControl = aControls.Item(lIdx)
            Select Case UCase(TypeName(lControl))
                Case "LABEL", "FRAME", "COMMANDBUTTON", "OPTIONBUTTON", "MENU", "CHECKBOX"
                    If lControl.Tag <> "" Then
                        If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                            lControl.Caption = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
                        End If
                        ' once translation is done and control is not in array CLEAR tag
                        If Not TypeOf lControl Is Frame And Not TypeOf lControl Is Label Then
                            lControl.Tag = ""
                        End If
                    End If
                Case "ARMGRID"
                    If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                      Call lControl.LoadConstants(ptStatic, mo_Db.GetFields(lLabels, "LOCAL_TEXT"), ctColumns)
                        End If
                    If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag & "_Title", , 1) >= 0 Then
                      lControl.Title = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
                    End If
                Case "TABSTRIP"
                    If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                        Dim lsa_TextArr() As String
                        Dim ll_Index As Long
                        
                        lsa_TextArr = Split(mo_Db.GetFields(lLabels, "LOCAL_TEXT"), SEP)
                        
                        For ll_Index = LBound(lsa_TextArr, 1) To UBound(lsa_TextArr, 1)
                            lControl.Tabs(ll_Index + 1).Caption = lsa_TextArr(ll_Index)
                        Next
                    End If
                    ' once translation is done and control is not in array CLEAR tag
                    lControl.Tag = ""
                Case "MSFLEXGRID", "TOOLBARCONTROL", "TEXTBOX", "ARMCHECKVIEW", "ARMCOMBOBOX", "A_CALOCX", "OPTIONBUTTON", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "TOOLBR", "SPINBUTTON"
                    ' Do nothing !
                Case Else
                    'debug.print "LoadLabels " & UCase(TypeName(lControl))
            End Select
        Set lControl = Nothing
    Next
    
    ' SPECIAL INITIALIZATION
    ' Title
    If mo_Db.Find(lLabels, "FIELD_NAME", "title", , 1) >= 0 Then
        ms_Title = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
    End If

    Call mo_Db.Close(lLabels)

    Exit Sub

ErrHandler:
    If lLabels > 0 Then
        Call mo_Db.Close(lLabels)
    End If
    Call ErrorHandler(Extender.Name & ".LoadLabels")
End Sub

Private Function GetContainedControlsChain(ByVal ao_parent As Object) As Collection
On Error GoTo ErrHandler
    Dim lo_retCollection As New Collection
    Dim lo_Control As Object
    
    For Each lo_Control In Controls
        If Not TypeOf lo_Control.Container Is SPA_Admin_MKT Then
            If ao_parent.hwnd = lo_Control.Container.hwnd Then
                If TypeOf lo_Control Is Frame Then
                    Dim lo_aux_collection As New Collection
                    Dim ll_i As Long
                    Set lo_aux_collection = GetContainedControlsChain(lo_Control)
                    For ll_i = 1 To lo_aux_collection.Count
                        lo_retCollection.Add (lo_aux_collection.Item(ll_i))
                    Next
                Else
                    Call lo_retCollection.Add(lo_Control)
                End If
            End If
        End If
    Next
    Set GetContainedControlsChain = lo_retCollection
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetContainedControlsChain()")
End Function

' as_Name equals to Tag definition string

Private Function GetControl(ByVal ao_array As Object, ByVal as_Name As String) As Object
On Error GoTo ErrHandler
    Dim lo_ctrl As Object
    For Each lo_ctrl In ao_array
        If StrComp(lo_ctrl.Tag, as_Name, vbTextCompare) = 0 Then
            Set GetControl = lo_ctrl
            Exit For
        End If
    Next
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetControl()")
End Function

Private Sub SetEnabled(ByVal ao_srcCtrl As Object, ByVal ab_Value As Boolean)
On Error GoTo ErrHandler
    Dim lo_ctrl As Object
    For Each lo_ctrl In ao_srcCtrl
        Call SetEnabledCtrl(lo_ctrl, ab_Value)
    Next
    Exit Sub
ErrHandler:
     Call ErrorHandler(Extender.Name & ".SetEnabled()")
End Sub

Private Sub SetEnabledCtrl(ByRef ao_ctrl As Control, ByVal ab_Value As Boolean)
On Error GoTo ErrHandler
        Select Case UCase(TypeName(ao_ctrl))
        Case "TEXTBOX"
            ao_ctrl.Locked = Not ab_Value
            ao_ctrl.BackColor = IIf(ab_Value, CL_COLOR_ENABLED, CL_COLOR_DISABLED)
        Case "TABSTRIP", "A_CALOCX", "ARMCOMBOBOX", "FRAME", "DIRLISTBOX", "DRIVELISTBOX", "FILELISTBOX", "OPTIONBUTTON", "ARMTREEVIEW", "COMMANDBUTTON", "PICTUREBOX", "CHECKBOX", "IMAGECOMBO"
            ao_ctrl.Enabled = ab_Value
        Case "ARMPICKER"
            ao_ctrl.Enabled = ab_Value
        Case "ARMGRID"
        End Select
    Exit Sub
ErrHandler:
     Call ErrorHandler(Extender.Name & ".SetEnabledCtrl()")
End Sub


' loads values from cursor into form. if cursor=0 then reset whole detail
Private Sub Item_LoadValues(ByVal as_Key As String)
On Error GoTo ErrHandler
    Dim ls_req As String
    Dim ll_cursor As Long
    Dim ls_EditRequest As String
    
    mb_Initializing = True
    If as_Key <> "" Then
        Debug.Assert (isNumeric(as_Key))
        
        ' load main record
        ls_req = Replace(ReplaceCommonPlaceholders(REQ_SELECT_SPA_MKT), "$SPM_Code$", as_Key, , , vbTextCompare)
        ll_cursor = OpenSQLSafe(mo_Db, ls_req)
        
        txt_Key.Text = as_Key
        
        Call LoadDataToForm(ll_cursor, UserControl.Controls, Me)
        
        ml_iConcurrency = mo_Db.GetFields(ll_cursor, "iConcurrency")
        
        Call mo_Db.Close(ll_cursor)
        ll_cursor = 0
        
        ckv_Countries.Calling_Key_Values = as_Key
    
        ls_EditRequest = ReplaceCommonPlaceholders("exec SPA_Countries_Lst $SPM_Code$, $Language_Code$")
        ls_EditRequest = Replace(ls_EditRequest, "$SPM_Code$", as_Key, , , vbTextCompare)
        
        ckv_Countries.RoleList(2).RequestLoad = ls_EditRequest
        ckv_Countries.LoadEditLists
        
        ckv_Countries.LoadList
        
        Dim ls_gridRequest As String
        ls_gridRequest = ReplaceCommonPlaceholders("exec SPA_AuthCountries_Active $SPM_Code$, $Language_Code$")
        ls_gridRequest = Replace(ls_gridRequest, "$SPM_Code$", as_Key, , , vbTextCompare)
        
        Call grd_Active.Load(ls_gridRequest, False)
        
    Else
        ' load default values
        txt_Key.Text = "NEW"
        txt_Date.Text = Format(Now, "DD/MM/YYYY")
        txt_creator.Text = ms_LoginName
        
        ckv_Countries.Calling_Key_Values = ""
        ls_EditRequest = ReplaceCommonPlaceholders("exec SPA_Countries_Lst NULL,$Language_Code$")
        ckv_Countries.RoleList(2).RequestLoad = ls_EditRequest
        'Call ckv_Countries.Init
        ckv_Countries.LoadEditLists
        ckv_Countries.LoadList
        
        grd_Active.ClearGrid
        grd_Active.Requests = ""
        
    End If
    
    mb_Initializing = False

    Exit Sub
ErrHandler:
    If ll_cursor > 0 Then
        Call mo_Db.Close(ll_cursor)
        ll_cursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".Item_LoadValues")
End Sub

' free resources
Private Sub Item_Cleanup()
On Error GoTo ErrHandler
    mb_Initializing = True
    mb_Initializing = False
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Cleanup")
End Sub

' clear all controls values
Private Sub Item_Clear()
On Error GoTo ErrHandler
    mb_Initializing = True
    Call ClearForm(UserControl.Controls, fra_detail)
    mb_Initializing = False
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Clear")
End Sub

' initialize view mode
Private Sub Item_ViewInit(ByVal as_detailKey As Variant)
On Error GoTo ErrHandler
    
    Call ResetScreen(ArmScreenMode.smView)
    Call Item_Clear
    
    ' loading values
    Call Item_LoadValues(CStr(as_detailKey(0)))
    
    Call UpdateUI(ArmScreenMode.smView)
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_ViewInit")
End Sub

' initialize delete mode
Private Sub Item_DeleteInit(ByVal as_detailKey As Variant)
On Error GoTo ErrHandler
    
    Call ResetScreen(ArmScreenMode.smDelete)
    Call Item_Clear
        
    Call Item_LoadValues(CStr(as_detailKey(0)))
    
    Call UpdateUI(ArmScreenMode.smDelete)
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_DeleteInit")
End Sub


' initialize update mode
Private Sub Item_AddInit()
On Error GoTo ErrHandler
    ' clearing form
    Call ResetScreen(ArmScreenMode.smAdd)
    Call Item_Clear
        
    Call Item_LoadValues("")
    
    Call UpdateUI(ArmScreenMode.smAdd)
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_AddInit")
End Sub

' initialize update mode
Private Sub Item_UpdateInit(ByVal as_detailKey As Variant)
On Error GoTo ErrHandler
    ' clearing form
    Call ResetScreen(ArmScreenMode.smUpdate)
    Call Item_Clear
        
    Call Item_LoadValues(CStr(as_detailKey(0)))
    
    Call UpdateUI(ArmScreenMode.smUpdate)
    
    
    If chk_dropped.Value = vbChecked Then
        ' deleted task cannot by edited
        Call MsgBox(MsgText(ErrMsgUpdateDeletedTask, ms_Language_Code, "#It is not possible to update already deleted task!"), vbInformation)
        ' move to view mode
        Call popScreenMode
        Call ResetScreen(ArmScreenMode.smView)
        Call UpdateUI(ArmScreenMode.smView)
    End If
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_UpdateInit")
End Sub

' deletes item
Private Function Item_Delete(ByVal av_oldKey As Variant) As Variant
On Error GoTo ErrHandler
Dim lb_InTran As Boolean

    If SendMessage("Delete record ?", vbQuestion + vbYesNo) = vbYes Then
    
        If Not GetToken Then
            Call MsgBox(MsgText(mo_tokenManager.LastErrorCode, ms_Language_Code, mo_tokenManager.lastErrorMsg), vbInformation)
            Exit Function
        End If
    
        Call ExecuteSQLSafe(mo_Db, "BEGIN TRAN Item_Del")
        lb_InTran = True
        
        ms_ServerDate = GetServerDate()
        ms_ErrMessage = ""
        
        Call Item_DeleteDB(av_oldKey(0))
    
        If ms_ErrMessage <> "" Then
            GoTo ErrHandler
        End If
    
        Call ExecuteSQLSafe(mo_Db, "COMMIT TRAN Item_Del")
        lb_InTran = False
    
        Call ReleaseToken
    
        RaiseEvent OnItemDelete(av_oldKey)

        Call Item_Exit
        
        Item_Delete = av_oldKey
    End If
    Exit Function
ErrHandler:
    If lb_InTran Then
        Call mo_Db.ExecuteSQL("ROLLBACK TRAN Item_Del")
        lb_InTran = False
    End If
    Call UpdateError(True)
    Call ReleaseToken
    Call UpdateError(False)
    If ms_ErrMessage <> "" Then
        Err.Clear
        Call MsgBox(ms_ErrMessage, vbInformation)
        Exit Function
    End If
   If Err.Number = SQLBadRowAffectedCount Then
        Err.Clear
        Call MsgBox(MsgText(ErrMsgDuplicateLevel, ms_Language_Code, "#Someone changed detail of this record and detail screen will be reloaded."), vbInformation)
        Call Item_Restore(av_oldKey)
        Exit Function
    End If
    Call ErrorHandler(Extender.Name & ".Item_Delete")
End Function

' workw with smView, smUpdate and smDelete mode
Private Sub Item_Restore(ByVal as_detailKey As Variant)
On Error GoTo ErrHandler
    ' clearing form
    Call ResetScreen(activeScreenMode)
    Call Item_Clear
    
    Call Item_LoadValues(CStr(as_detailKey(0)))
    Call UpdateUI
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Restore")
End Sub

' adds current edited item
Private Function Item_Add() As Variant
On Error GoTo ErrHandler
Dim lb_InTran As Boolean
Dim ll_Idx    As Long
Dim ll_Idx2   As Long

    lb_InTran = False

    ' check values and throw message if neccessary
    If Not Item_Check() Then
        Exit Function
    End If
        
    If Not GetToken Then
        Call MsgBox(MsgText(mo_tokenManager.LastErrorCode, ms_Language_Code, mo_tokenManager.lastErrorMsg), vbInformation)
        Exit Function
    End If
        
    Dim ls_newCode As String
    ' get new code
    ls_newCode = mo_Db.SQLNextID(C_ID_KEY)
    txt_Key.Text = ls_newCode
    
    ReDim ma_AuthCountries_ID_LIST(-1 To -1)
    
    For ll_Idx = 1 To ckv_Countries.RoleCount
        If ckv_Countries.RoleList(ll_Idx).Mode = clModeEdit Then
            For ll_Idx2 = 1 To ckv_Countries.RoleList(ll_Idx).Count
                If ckv_Countries.RoleList(ll_Idx).Items(ll_Idx2).CurrentChecked = True And _
                   ckv_Countries.RoleList(ll_Idx).Items(ll_Idx2).CurrentChecked <> ckv_Countries.RoleList(ll_Idx).Items(ll_Idx2).OriginalChecked Then
                    If UBound(ma_AuthCountries_ID_LIST) = -1 Then
                        ReDim ma_AuthCountries_ID_LIST(1)
                    Else
                        ReDim Preserve ma_AuthCountries_ID_LIST(UBound(ma_AuthCountries_ID_LIST) + 1)
                    End If
                    ma_AuthCountries_ID_LIST(UBound(ma_AuthCountries_ID_LIST) - 1) = mo_Db.SQLNextID(C_ID_KEY_AUTH_COUNTRIES)
                End If
            Next
        End If
    Next
    
    Call ExecuteSQLSafe(mo_Db, "BEGIN TRAN Item_Add")
    lb_InTran = True
    
    ms_ServerDate = GetServerDate()
    ms_ErrMessage = ""
    
    Call Item_AddDB(ls_newCode)
    
    If ms_ErrMessage <> "" Then
        GoTo ErrHandler
    End If

    Call ExecuteSQLSafe(mo_Db, "COMMIT TRAN Item_Add")
    lb_InTran = False
    
    Call ReleaseToken

    RaiseEvent OnItemAdd(CVar(Array(ls_newCode)), Build_SrzString(UserControl.Controls, Me))

    Call Item_Exit
    
    Item_Add = CVar(Array(ls_newCode))
    Exit Function
ErrHandler:
    If lb_InTran Then
        Call mo_Db.ExecuteSQL("ROLLBACK TRAN Item_Add")
        lb_InTran = False
    End If
    Call UpdateError(True)
    Call ReleaseToken
    Call UpdateError(False)
    If ms_ErrMessage <> "" Then
        Err.Clear
        Call MsgBox(ms_ErrMessage, vbInformation)
        Exit Function
    End If
    If Err.Number = SQLBadRowAffectedCount Then
        Call MsgBox("Error occured while inserting record, please contact IT")
        Exit Function
    End If

    Call ErrorHandler(Extender.Name & ".Item_Add")
End Function

' TAKE TOKEN ONLY IF STATUS IS SUBMITED
Private Function GetToken() As Boolean
On Error GoTo ErrHandler
    GetToken = mo_tokenManager.GetToken(C_ABPE_SPA_TOKEN, SPA_Admin_ScreenValidate)
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetToken")
End Function

Private Sub ReleaseToken()
On Error GoTo ErrHandler
    Call mo_tokenManager.ReleaseToken
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ReleaseToken")
End Sub

' update current edited item
Private Function Item_Update(ByVal av_oldKey As Variant) As Variant
On Error GoTo ErrHandler
Dim lb_InTran As Boolean
Dim ll_Idx    As Long
Dim ll_Idx2   As Long

    If Not GetToken Then
        Call MsgBox(MsgText(mo_tokenManager.LastErrorCode, ms_Language_Code, mo_tokenManager.lastErrorMsg), vbInformation)
        Exit Function
    End If
    
    lb_InTran = False
    If Not Item_Check() Then
        Exit Function
    End If
    
    ReDim ma_AuthCountries_ID_LIST(-1 To -1)
    
    For ll_Idx = 1 To ckv_Countries.RoleCount
        If ckv_Countries.RoleList(ll_Idx).Mode = clModeEdit Then
            For ll_Idx2 = 1 To ckv_Countries.RoleList(ll_Idx).Count
                If ckv_Countries.RoleList(ll_Idx).Items(ll_Idx2).CurrentChecked = True And _
                   ckv_Countries.RoleList(ll_Idx).Items(ll_Idx2).CurrentChecked <> ckv_Countries.RoleList(ll_Idx).Items(ll_Idx2).OriginalChecked Then
                    If UBound(ma_AuthCountries_ID_LIST) = -1 Then
                        ReDim ma_AuthCountries_ID_LIST(1)
                    Else
                        ReDim Preserve ma_AuthCountries_ID_LIST(UBound(ma_AuthCountries_ID_LIST) + 1)
                    End If
                    ma_AuthCountries_ID_LIST(UBound(ma_AuthCountries_ID_LIST) - 1) = mo_Db.SQLNextID(C_ID_KEY_AUTH_COUNTRIES)
                End If
            Next
        End If
    Next
    
    Call ExecuteSQLSafe(mo_Db, "BEGIN TRAN Item_Upd")
    lb_InTran = True
    
    ms_ServerDate = GetServerDate()
    ms_ErrMessage = ""
    
    Call Item_UpdateDB(av_oldKey(0))
        
    
    Call ExecuteSQLSafe(mo_Db, "COMMIT TRAN Item_Upd")
    lb_InTran = False
    
    Call ReleaseToken
    
    RaiseEvent OnItemUpdate(av_oldKey, Build_SrzString(UserControl.Controls, Me))

    Call Item_Exit

    Item_Update = CVar(Array(av_oldKey(0)))

    Exit Function
ErrHandler:
    If lb_InTran Then
        Call mo_Db.ExecuteSQL("ROLLBACK TRAN Item_Upd")
        lb_InTran = False
    End If
    Call UpdateError(True)
    Call ReleaseToken
    Call UpdateError(False)
    If ms_ErrMessage <> "" Then
        Err.Clear
        Call MsgBox(ms_ErrMessage, vbInformation)
        Exit Function
    End If
    If Err.Number = SQLBadRowAffectedCount Then
        Err.Clear
        Call MsgBox(MsgText(ErrMsgDuplicateLevel, ms_Language_Code, "#Someone changed detail of this record and detail screen will be reloaded."), vbInformation)
        Call Item_Cleanup
        Call Item_Restore(av_oldKey)
        Exit Function
    End If
    Call ErrorHandler(Extender.Name & ".Item_Update")
End Function

Private Sub Item_AddDB(ByVal as_Code As Long)
On Error GoTo ErrHandler
    Dim ls_req As String

    ' common placeholders
    ls_req = ReplaceCommonPlaceholders(REQ_INSERT_SPA_MKT)
    ls_req = Item_ReplacePlaceholders(ls_req)
    
    Call ExecuteSQLSafe(mo_Db, ls_req, 1)

    ' save changed countries
    If ckv_Countries.SaveList = False Then
        Err.Raise (ArmErr.QuietException)
    End If
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_AddDb")
End Sub

Private Function GetGridKeyColumnFieldName(ByRef ao_grid As ArmGrid) As String
On Error GoTo ErrHandler
    Dim ll_Col As Long
    
    GetGridKeyColumnFieldName = ""
    For ll_Col = 0 To ao_grid.Cols - 1
        If ao_grid.Columns(ll_Col).Key Then
            ' we have key
            GetGridKeyColumnFieldName = ao_grid.Columns(ll_Col).FieldName
            Exit For
        End If
    Next

    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetGridKeyColumnFieldName")
End Function


Private Sub Item_UpdateDB(ByVal as_Code As String)
On Error GoTo ErrHandler
    Dim ls_req As String
    
    ' common placeholders
    ls_req = ReplaceCommonPlaceholders(REQ_UPDATE_SPA_MKT)
    ls_req = Item_ReplacePlaceholders(ls_req)
    
    Call ExecuteSQLSafe(mo_Db, ls_req, 1)
    
    ' save changed countries
    Call ckv_Countries.SaveList
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_UpdateDb")
End Sub

Private Sub Item_DeleteDB(ByVal as_Code As String)

    Const REQ_DELETE_CT_FUTUR As String = "SPA_AuthCountries_del4 $SPM_Code$"
    Const REQ_DELETE_CT_UNUSED As String = "SPA_AuthCountries_del5 $SPM_Code$"
    Const REQ_CLOSE_CT_UNUSED As String = "exec SPA_AuthCountries_del6 $SPM_Code$, $U_Code$"
    Const REQ_CLOSE_CT_USED As String = "exec SPA_AuthCountries_del2 $SPM_Code$, $U_Code$"
    
    Const REQ_CLOSE_USERRIGHT As String = "exec SPA_AuthMarket_CloseUserRights $SPM_Code$, $U_Code$"
    Const REQ_GET_COMBINATION As String = "exec SPA_AuthMarket_GetCombinations $SPM_Code$"

On Error GoTo ErrHandler
    
    
    Dim ls_ReqDelCTFutur As String              ' Delete the countries links for future
    Dim ls_ReqDelCTUnused As String             ' Delete the countries links of today unused
    Dim ls_ReqCloseCTUnused As String           ' Close the countries not used today at Today - 1
    Dim ls_ReqCloseCTUsed                       ' Close the countries used today at Today
    Dim ls_ReqCloseUserRights As String         ' Close all users rights
    Dim ls_ReqGetCombinationList As String      ' Get the products group / auth market combination list, for close them
    Dim ls_ReqDropMarket As String              ' Drop the market
    
    Dim lc_Combination As Long                  ' Contains the combination
    
    
    '__STEP 1 - Create requests
    
    ' Delete the countries links for future
    ls_ReqDelCTFutur = REQ_DELETE_CT_FUTUR
    ls_ReqDelCTFutur = Replace(ls_ReqDelCTFutur, "$SPM_Code$", as_Code, , , vbTextCompare)
    
    ' Delete the countries links of today unused
    ls_ReqDelCTUnused = REQ_DELETE_CT_UNUSED
    ls_ReqDelCTUnused = Replace(ls_ReqDelCTUnused, "$SPM_Code$", as_Code, , , vbTextCompare)
    
    
    ' Close the countries not used today at Today - 1
    ls_ReqCloseCTUnused = REQ_CLOSE_CT_UNUSED
    ls_ReqCloseCTUnused = Replace(ls_ReqCloseCTUnused, "$SPM_Code$", as_Code, , , vbTextCompare)
    ls_ReqCloseCTUnused = Replace(ls_ReqCloseCTUnused, "$U_Code$", ml_U_Code, , , vbTextCompare)
    
    ' Close the countries used today at Today
    ls_ReqCloseCTUsed = REQ_CLOSE_CT_USED
    ls_ReqCloseCTUsed = Replace(ls_ReqCloseCTUsed, "$SPM_Code$", as_Code, , , vbTextCompare)
    ls_ReqCloseCTUsed = Replace(ls_ReqCloseCTUsed, "$U_Code$", ml_U_Code, , , vbTextCompare)

    ' Close all users rights
    ls_ReqCloseUserRights = REQ_CLOSE_USERRIGHT
    ls_ReqCloseUserRights = Replace(ls_ReqCloseUserRights, "$SPM_Code$", as_Code, , , vbTextCompare)
    ls_ReqCloseUserRights = Replace(ls_ReqCloseUserRights, "$U_Code$", ml_U_Code, , , vbTextCompare)
    
    ' Get the products group / auth market combination list, for close them
    ls_ReqGetCombinationList = REQ_GET_COMBINATION
    ls_ReqGetCombinationList = Replace(ls_ReqGetCombinationList, "$SPM_Code$", as_Code, , , vbTextCompare)
    
    lc_Combination = OpenSQLSafe(mo_Db, ls_ReqGetCombinationList)
    
    ' Drop the market
    ls_ReqDropMarket = REQ_DELETE_SPA_MKT
    ls_ReqDropMarket = ReplaceCommonPlaceholders(ls_ReqDropMarket)
    ls_ReqDropMarket = Item_ReplacePlaceholders(ls_ReqDropMarket)
    
    
    '__STEP 2 - Execute Request (starting by the one which has the more chance to failed for concurrency)
    
    ' Drop the market
    Call ExecuteSQLSafe(mo_Db, ls_ReqDropMarket, 1)
    
    ' Delete the countries links for future
    Call ExecuteSQLSafe(mo_Db, ls_ReqDelCTFutur)
    ' Delete the countries links of today unused
    Call ExecuteSQLSafe(mo_Db, ls_ReqDelCTUnused)
    ' Close the countries not used today at Today - 1
    Call ExecuteSQLSafe(mo_Db, ls_ReqCloseCTUnused)
    ' Close the countries used today at Today
    Call ExecuteSQLSafe(mo_Db, ls_ReqCloseCTUsed)
     
     ' Get the products group / auth market combination list, for close them
    Dim ll_Idx As Long, ll_Count As Long
    ll_Count = mo_Db.RowCount(lc_Combination) - 1
    For ll_Idx = 0 To ll_Count
        Call SPA_Admin_PG_MKT_Delete(mo_Db, mo_Db.GetFields(lc_Combination, "SPGAM_ID"), mo_Db.GetFields(lc_Combination, "VDate_Start"), ms_ServerDate, ml_U_Code)
    Next
    mo_Db.Close (lc_Combination)
     
     
    Exit Sub
ErrHandler:
    mo_Db.Close (lc_Combination)
    Call ErrorHandler(Extender.Name & ".Item_DeleteDb")
End Sub

' specia type od serialized string filed1_name sep1 data1 sep1 data2 sep field2_name ....
Private Function Build_SrzStringFromGrid(ByRef ao_grid As Control) As String
On Error GoTo ErrHandler
    Dim ls_ret As String
    Dim ls_Data As String
    Dim ll_Row As Long
    Build_SrzStringFromGrid = ""
    
    Dim ll_Col As Long
    Dim lo_Column As ArmColumn
    
    For ll_Col = 0 To ao_grid.Cols - 1
        Set lo_Column = ao_grid.Columns(ll_Col)
        ls_Data = ""
        For ll_Row = 0 To ao_grid.Rows - 1
            ls_Data = IIf(ll_Row = 0, "", ls_Data & SEP1) & lo_Column.GetData(ll_Row)
        Next
        ls_ret = IIf(ll_Col = 0, "", ls_ret & SEP) & lo_Column.FieldName & SEP1 & ls_Data
    Next
    
    Build_SrzStringFromGrid = ls_ret
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Build_SrzStringFromGrid")
End Function

Private Function Build_SrzStringFromGridLine(ByRef ao_grid As Control, Optional ByVal al_Row As Long = -1) As String
On Error GoTo ErrHandler
    Dim ls_ret As String
    Build_SrzStringFromGridLine = ""
    If al_Row = -1 Then
        If ao_grid.SelectedCount > 0 Then
            al_Row = ao_grid.Row
        Else
            Call Err.Raise(ArmErr.InvalidArgument, "", "No row selected in grid.")
        End If
    End If
    
    Dim ll_Col As Long
    Dim lo_Column As ArmColumn
    
    For ll_Col = 0 To ao_grid.Cols - 1
        Set lo_Column = ao_grid.Columns(ll_Col)
        ls_ret = IIf(ll_Col = 0, "", ls_ret & SEP) & lo_Column.FieldName & SEP1 & lo_Column.GetData(al_Row)
    Next
    
    Build_SrzStringFromGridLine = ls_ret
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Build_SrzStringFromGridLine")
End Function

Private Function Build_SrzStringFromControl(ByRef aControl As Control) As String
On Error GoTo ErrHandler
    Dim ls_SrzString As String
    Dim lValues As Variant
    Dim ls_TempTag As String
    Dim ls_Str As String

    Build_SrzStringFromControl = ""
                
    ls_TempTag = aControl.Tag & SEP
    lValues = Split(ls_TempTag, SEP)
    
    Select Case UCase(TypeName(aControl))
        Case "TEXTBOX"
                Select Case lValues(1)
                    Case "Text", "Date"
                        ls_SrzString = ls_SrzString & lValues(0) & SEP1 & aControl.Text
                    Case "Num"
                        ls_Str = Replace(aControl.Text, ms_ThousandSeparator, "")
                        ls_Str = Replace(ls_Str, ms_DecimalSeparator, ".")
                        ls_SrzString = ls_SrzString & lValues(0) & SEP1 & ls_Str
               End Select
        
        Case "ARMCOMBOBOX"
            If Not aControl.SelectedItem Is Nothing Then
                ls_SrzString = ls_SrzString & lValues(0) & SEP1 & aControl.SelectedItem.Key & SEP
                ls_SrzString = ls_SrzString & lValues(1) & SEP1 & aControl.SelectedItem.GetData(1)
            Else
                ls_SrzString = ls_SrzString & lValues(0) & SEP1 & "NULL" & SEP
                ls_SrzString = ls_SrzString & lValues(1) & SEP1 & "" & SEP
            End If
        Case "OPTIONBUTTON"
            
        Case "CHECKBOX"
            ls_SrzString = ls_SrzString & lValues(0) & SEP1 & IIf(aControl.Value = vbChecked, "X", "") & SEP
        
        Case "A_CALOCX"
            ls_SrzString = ls_SrzString & lValues(0) & SEP1 & aControl.date_courte
            
            
        Case "LABEL", "FRAME", "DIRLISTBOX", "FILELISTBOX", "DRIVELISTBOX", "TOOLBARCONTROL", "ARMCHECKVIEW"
            'Do Nothing
        
        Case "ARMGRID"
            ' do nothing
'            If aControl.SelectedCount > 0 Then
'                ls_SrzString = ls_SrzString & Build_SrzStringFromGridLine(aControl)
'            End If
        Case "ARMPICKER"
            ls_SrzString = ls_SrzString & lValues(0) & SEP1 & aControl.ItemCode & SEP
            ls_SrzString = ls_SrzString & lValues(1) & SEP1 & aControl.ItemDescription
        
        Case Else
            Debug.Print "Build_SrzStringFromControl  -> " & UCase(TypeName(aControl))
    End Select

    Build_SrzStringFromControl = ls_SrzString
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Build_SrzStringFromControl")
End Function


Private Function Build_SrzString(ByRef aControls As Variant, ByRef aContainer As Object) As String
On Error GoTo ErrHandler
    Dim ls_SrzString As String
    Dim lo_Control As CheckBox
    Dim lIdx As Long, lCount As Long
    
    Dim ls_Str As String
    Dim lControl As Control
   
    
        lCount = aControls.Count - 1
        ls_SrzString = ""
    
        For lIdx = 0 To lCount
            Set lControl = aControls.Item(lIdx)
            If HasContainer(lControl, aContainer) Then
                ls_Str = Build_SrzStringFromControl(lControl)
                If ls_Str <> "" Then
                    ls_SrzString = ls_SrzString & ls_Str & SEP
                End If
                
            End If
            Set lControl = Nothing
        Next

    ls_SrzString = Trim(ls_SrzString)
    Build_SrzString = ls_SrzString
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("Build_SrzString")
End Function

Private Sub FillDataSrcArray(ByRef ao_dataSrc As Dictionary, ByVal as_SrzFields As String)
On Error GoTo ErrHandler
    
    Dim ll_i As Long
    Dim lsa_DataFields() As String
    Dim lv_Values As Variant
    lsa_DataFields = Split(as_SrzFields, SEP)
    
    For ll_i = LBound(lsa_DataFields) To UBound(lsa_DataFields)
        lv_Values = Split(lsa_DataFields(ll_i), SEP1)
        If UBound(lv_Values) >= 1 Then
            Call ao_dataSrc.Add(lv_Values(0), lv_Values(1))
        End If
    Next
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("FillDataSrcArray")
End Sub

Private Function IsInArray(ByVal as_val As String, ByRef av_Array As Variant) As Boolean
On Error GoTo ErrHandler
    Dim ll_i As Long
    IsInArray = False
    For ll_i = LBound(av_Array) To UBound(av_Array)
        If StrComp(av_Array(ll_i), as_val, vbTextCompare) <> 0 Then Exit Function
    Next
    IsInArray = True
    Exit Function
ErrHandler:
    Call ErrorHandler("IsInArray")
End Function


Private Function GetFieldValueFromSrz(ByVal as_SrzFields As String, ByVal as_Param As String) As String
On Error GoTo ErrHandler
    
    Dim lv_SrzFields As Variant
    Dim lv_Values
    Dim ll_Count As Long
    Dim ll_Nb As Long
       
    If right(as_SrzFields, 2) <> SEP Then as_SrzFields = as_SrzFields & SEP
       
    lv_SrzFields = Split(as_SrzFields, SEP)
    ll_Nb = UBound(lv_SrzFields) - 1

    For ll_Count = 0 To ll_Nb
        lv_Values = Split(lv_SrzFields(ll_Count), SEP1)
         If UCase(as_Param) = UCase(lv_Values(0)) Then
           GetFieldValueFromSrz = lv_Values(1)
           Exit For
         End If
    Next ll_Count
    
    Exit Function
ErrHandler:
    Call ErrorHandler("GetFieldValueFromSrz")
End Function

Private Sub SetCheckBoxDB(ByVal al_cursor As Long, ByVal as_keyField As String, ByRef ao_CheckBox As VB.CheckBox, Optional ByVal as_checked As String = "X")
On Error GoTo ErrHandler
    Dim lv_val As Variant
    lv_val = mo_Db.GetFields(al_cursor, as_keyField)
    If Not IsEmpty(lv_val) Then
        ao_CheckBox.Value = IIf(lv_val = as_checked, vbChecked, vbUnchecked)
    Else
        ao_CheckBox.Value = vbUnchecked
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SetCheckBoxDB")
End Sub


Private Sub SetComboBoxTextDB(ByVal al_cursor As Long, ByVal as_keyField As String, ByVal as_DescField As String, ByRef ao_Combobox As ArmCombobox, Optional ByVal ab_clearIfNotExists As Boolean = True)
On Error GoTo ErrHandler
    Dim lv_val As Variant
    lv_val = mo_Db.GetFields(al_cursor, CVar(Array(as_keyField, as_DescField)))
    If Not IsEmpty(lv_val) Then
        Debug.Assert (UBound(lv_val) = 1)
        Call SetComboBoxText(ao_Combobox, CStr(lv_val(0)), CStr(lv_val(1)))
    Else
        If ab_clearIfNotExists Or mo_Db.GetFieldIndex(al_cursor, as_keyField) <> -1 Then
            Call ao_Combobox.Clear
        End If
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SetComboBoxTextDB")
End Sub

' Sets combobox selected item
' Params:
' ao_ComboBox (ArmCombobox)
' as_Key (String)
' as_Desc (String)
Private Sub SetComboBoxText(ByRef ao_Combobox As ArmCombobox, ByVal as_Key As String, ByVal as_Desc As String)
On Error GoTo ErrHandler
    If Not ao_Combobox.SearchItem(as_Key) Then
        ' key not found ... set value from parameter
        If as_Key = "" Or as_Key = "0" Then     ' zero or empty string is not valid key
            Set ao_Combobox.SelectedItem = Nothing
        Else
            Call ao_Combobox.AddItem(Array(as_Key, as_Desc), True)
            ' to make vb raise event
            Call ao_Combobox.SearchItem(as_Key)
        End If
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SetComboBoxText")
End Sub

Private Function Item_ReplacePlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler
    ' general
    Dim ls_ret As String
    ls_ret = ReplaceRequestByFrameData(as_Request, fra_detail)
    
    ' default
    ls_ret = ReplacePlaceHolder(ls_ret, "$iConcurrency$", ml_iConcurrency)
    ls_ret = ReplacePlaceHolder(ls_ret, "$EMail_Created_Sent$", "NULL")
    ls_ret = ReplacePlaceHolder(ls_ret, "$EMail_Completed_Sent$", "NULL")
    ls_ret = ReplacePlaceHolder(ls_ret, "$EMail_Created$", "''")
    ls_ret = ReplacePlaceHolder(ls_ret, "$EMail_Completed$", "''")
    
    Item_ReplacePlaceholders = ls_ret
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_ReplacePlaceholders")
End Function

' exits mode to main
Private Sub Item_Exit()
On Error GoTo ErrHandler
    
    ' pop last item in screen mode stack
    Call popScreenModeUntil(smMain)
    
    Call ResetScreen(activeScreenMode)
    Call UpdateUI
    
    RaiseEvent OnExit
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Exit")
End Sub

Private Function Item_Check() As Boolean
On Error GoTo ErrHandler
        
    Dim lv_MsgReplaceInfo(0, 1) As String
    Dim lo_Control As Object
    Dim ls_LabelCaption As String
    Dim ll_CtrlIndex As Long
    Dim lb_Found As Boolean
    Dim lo_mandatoryField As Variant
    
    If IsArray(moa_ListFieldsMandatory) Then
    
        For Each lo_mandatoryField In moa_ListFieldsMandatory
            Set lo_Control = lo_mandatoryField(0)
            If lo_mandatoryField(1) >= 0 Then
                ls_LabelCaption = lbl_Label(lo_mandatoryField(1)).Caption
            Else
                ls_LabelCaption = ""
            End If
            Select Case UCase(TypeName(lo_Control))
                Case "FRAME", "LABEL", "MSFLEXGRID", "TOOLBARCONTROL"
                    ' Do nothing !
                
                Case "TEXTBOX"
                    If lo_Control.Visible And (lo_Control.Text = "") Then
                        lv_MsgReplaceInfo(0, 0) = "$LabelCaption$"
                        lv_MsgReplaceInfo(0, 1) = ls_LabelCaption
                        Call MsgBox(MsgText(2120, ms_Language_Code, "The field " & lv_MsgReplaceInfo(0, 1) & " is mandatory.", lv_MsgReplaceInfo), vbInformation)
                        lo_Control.SetFocus
                        Exit Function
                    End If
                Case "ARMCHECKVIEW"
                     If lo_Control.Visible And (lo_Control.RoleList("EDIT").CheckedCount = 0) Then
                        lv_MsgReplaceInfo(0, 0) = "$LabelCaption$"
                        lv_MsgReplaceInfo(0, 1) = ls_LabelCaption
                        Call MsgBox(MsgText(2120, ms_Language_Code, "The field " & lv_MsgReplaceInfo(0, 1) & " is mandatory.", lv_MsgReplaceInfo), vbInformation)
                        Call lo_Control.SetFocus
                        Exit Function
                      End If
                Case "ARMGRID"
                Case "ARMCHECKVIEW", "COMMANDBUTTON", "A_CALOCX", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "TABSTRIP"
                
                Case "OPTIONBUTTON", "CHECKBOX"
                    'probably array of controls
                Case "OBJECT"
                    lb_Found = False
                    For ll_CtrlIndex = 0 To lo_Control.Count - 1
                        If UCase(TypeName(lo_Control(ll_CtrlIndex))) = "CHECKBOX" Then
                            If lo_Control(ll_CtrlIndex).Value = vbChecked Then
                                lb_Found = True
                                Exit For
                            End If
                        ElseIf UCase(TypeName(lo_Control(ll_CtrlIndex))) = "OPTIONBUTTON" Then
                            If lo_Control(ll_CtrlIndex).Value Then
                                lb_Found = True
                                Exit For
                            End If
                        Else
                            ' unknown array ???
                            lb_Found = True
                            Exit For
                        End If
                    Next
                    If Not lb_Found Then
                        lv_MsgReplaceInfo(0, 0) = "$LabelCaption$"
                        lv_MsgReplaceInfo(0, 1) = ls_LabelCaption
                        Call MsgBox(MsgText(2120, ms_Language_Code, "The field " & lv_MsgReplaceInfo(0, 1) & " is mandatory.", lv_MsgReplaceInfo), vbInformation)
                        Exit Function
                    End If
                Case "ARMCOMBOBOX"
                    If lo_Control.Visible And (lo_Control.SelectedItem Is Nothing) Then
                        lv_MsgReplaceInfo(0, 0) = "$LabelCaption$"
                        lv_MsgReplaceInfo(0, 1) = ls_LabelCaption
                        Call MsgBox(MsgText(2120, ms_Language_Code, "The field " & lv_MsgReplaceInfo(0, 1) & " is mandatory.", lv_MsgReplaceInfo), vbInformation)
                        Call lo_Control.SetFocus
                        Exit Function
                    End If
                Case "ARMPICKER"
                    If lo_Control.Visible And (CStr(lo_Control.ItemCode) = "") Then
                        lv_MsgReplaceInfo(0, 0) = "$LabelCaption$"
                        lv_MsgReplaceInfo(0, 1) = ls_LabelCaption
                        Call MsgBox(MsgText(2120, ms_Language_Code, "The field " & lv_MsgReplaceInfo(0, 1) & " is mandatory.", lv_MsgReplaceInfo), vbInformation)
                        lo_Control.SetFocus
                        Exit Function
                    End If
                Case "LISTVIEW"
                     If lo_Control.Visible And (GetCheckedCount(lo_Control) = 0) Then
                        lv_MsgReplaceInfo(0, 0) = "$LabelCaption$"
                        lv_MsgReplaceInfo(0, 1) = ls_LabelCaption
                        Call MsgBox(MsgText(2120, ms_Language_Code, "The field " & lv_MsgReplaceInfo(0, 1) & " is mandatory.", lv_MsgReplaceInfo), vbInformation)
                        Call lo_Control.SetFocus
                        Exit Function
                      End If
                Case Else
                    Debug.Print "Item_CheckMandatory " & UCase(TypeName(lo_Control))
            End Select
        Next
    End If
    
    ' check all numeric fields on detail
    If Not IsArray(moa_ListFieldsNumeric) Then
        Item_Check = True
        Exit Function
    End If
    
    Dim lValues As Variant
    Dim ls_Str As String, ls_TempTag As String

    For Each lo_mandatoryField In moa_ListFieldsNumeric
        Set lo_Control = lo_mandatoryField(0)
        If lo_mandatoryField(1) >= 0 Then
            ls_LabelCaption = lbl_Label(lo_mandatoryField(1)).Caption
        Else
            ls_LabelCaption = ""
        End If
        
        ls_TempTag = lo_Control.Tag & SEP
        lValues = Split(ls_TempTag, SEP)
        Select Case UCase(TypeName(lo_Control))
            Case "TEXTBOX"
                 Select Case lValues(1)
                     Case "Text"     ' no chceck needed
                     Case "Date"
                         If lo_Control.Visible And Not IsDate(lo_Control.Text) Then
                             lv_MsgReplaceInfo(0, 0) = "$LabelCaption$"
                             lv_MsgReplaceInfo(0, 1) = ls_LabelCaption
                             Call MsgBox(MsgText(2120, ms_Language_Code, "The field " & lv_MsgReplaceInfo(0, 1) & " is mandatory.", lv_MsgReplaceInfo), vbInformation)
                             lo_Control.SetFocus
                             Exit Function
                         End If
                     Case "Num"
                        ls_Str = Replace(lo_Control.Text, ".", ms_DecimalSeparator, , , vbTextCompare)
                        If lo_Control.Visible And Not isNumeric(ls_Str) Then
                             lv_MsgReplaceInfo(0, 0) = "$LabelCaption$"
                             lv_MsgReplaceInfo(0, 1) = ls_LabelCaption
                             Call MsgBox(MsgText(2131, ms_Language_Code, "The field " & lv_MsgReplaceInfo(0, 1) & " is mandatory.", lv_MsgReplaceInfo), vbInformation)
                             lo_Control.SetFocus
                             Exit Function
                         End If
                End Select
            
            Case "ARMCOMBOBOX", "OPTIONBUTTON", "CHECKBOX", "A_CALOCX", "LABEL", "FRAME", "DIRLISTBOX", "FILELISTBOX", "DRIVELISTBOX", "TOOLBARCONTROL", "ARMGRID", "ARMPICKER"
                ' do nothing
            
            Case Else
                Debug.Print "Item_Check  -> " & UCase(TypeName(lo_Control))
        End Select
    Next


    Item_Check = True

    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Check")
End Function

Private Function GetCheckedCount(ByRef ao_ListView As MSComctlLib.ListView) As Long
On Error GoTo ErrHandler

Dim lo_item As MSComctlLib.ListItem
Dim ll_Count As Long

    ll_Count = 0
    For Each lo_item In ao_ListView.ListItems
        If lo_item.Checked Then ll_Count = ll_Count + 1
    Next
    GetCheckedCount = ll_Count
    Exit Function
ErrHandler:
    Call ErrorHandler("GetCheckedCount")
End Function

Private Sub SetFocusToCtrl(ByRef ao_ctrl As Object)
On Error GoTo ErrHandler
    If ao_ctrl.Visible Then
        ao_ctrl.SetFocus
    End If
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".SetFocusToCtrl")
End Sub

Private Sub LockScreen(ByVal ab_lock As Boolean)

    Dim ll_errNumber As Long, ls_ErrSrc As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSrc = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    Static ll_Count As Long
    Static ll_Mousepointer As Long
    Static lb_Locked As Boolean
      
    ll_Count = ll_Count + IIf(ab_lock, 1, -1)
    Debug.Assert (ll_Count >= 0)
    
    ' First lock
    If Not lb_Locked And ab_lock Then
        ll_Mousepointer = Screen.MousePointer
        Screen.MousePointer = vbHourglass
        LockWindowUpdate UserControl.hwnd
        lb_Locked = True
    End If
    
    ' Unlock
    If ll_Count = 0 Then
        DoEvents ' Flush events
        LockWindowUpdate 0
        UserControl.Refresh ' Repaint immediately
        Screen.MousePointer = ll_Mousepointer
        lb_Locked = False
    End If
    
    Err.Number = ll_errNumber
    Err.Source = ls_ErrSrc
    Err.Description = ls_ErrDesc
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".LockScreen")
End Sub

Private Sub ResetScreen(ByVal au_Mode As ArmScreenMode)
On Error GoTo ErrHandler
    ' apply face
    Dim lo_ctrl As Object

    Select Case au_Mode
        Case smMain
            ' enable filtering a browsing
            Call SetEnabled(GetContainedControlsChain(fra_detail), False)
            
        Case smUpdate, smAdd
            ' we are in Update section
            Call SetEnabled(GetContainedControlsChain(fra_detail), True)
            
            
            Dim lIdx As Long, lCount As Long
            
            If IsArray(moa_ListFieldsToDisable) Then
                lCount = UBound(moa_ListFieldsToDisable)
            
                For lIdx = 0 To lCount
                    Call SetEnabledCtrl(moa_ListFieldsToDisable(lIdx), False)
                Next
            End If
            
        Case smDelete, smView
            ' we are in PreView section
            Call SetEnabled(GetContainedControlsChain(fra_detail), False)
        Case Else
            Debug.Assert (False)
    End Select

    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ResetScreen()")
End Sub


Private Function HasContainer(ByRef aControl As Control, ByRef aContainer As Object) As Boolean
    HasContainer = False
    Dim lControl As Control
 
    Set lControl = aControl
    While Not (lControl Is Nothing)
        On Error GoTo NotFound
        If lControl.Container Is aContainer Then
            Set lControl = Nothing
            HasContainer = True
            Exit Function
        End If
        Set lControl = lControl.Container
    Wend
 
NotFound:
    Set lControl = Nothing
    HasContainer = False
End Function
 
Private Function IsSub(ByVal av_Name As Object, ByRef aav_Names As Variant)
On Error GoTo ErrHandler
    IsSub = False
    
    Dim ll_Idx As Long
    For ll_Idx = LBound(aav_Names) To UBound(aav_Names)
    
        If av_Name Is aav_Names(ll_Idx) Then
            IsSub = True
            Exit Function
        End If
    Next ll_Idx
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".IsSub")
End Function

' Clear values for each control to not initiliazed
Private Sub ClearForm(ByRef aControls As Variant, ByRef aContainer As Object, Optional ByRef aav_Except As Variant)
On Error GoTo ErrHandler
 
    'mb_internal = True
 
    Dim lIdx As Long, lCount As Long, lControl As Object
    lCount = aControls.Count - 1
    For lIdx = 0 To lCount
        Dim lb_Process As Boolean
        lb_Process = True
        Set lControl = aControls.Item(lIdx)
        If Not IsMissing(aav_Except) Then
            If IsSub(lControl, aav_Except) Then
                lb_Process = False
            End If
        End If
        If HasContainer(lControl, aContainer) And lb_Process Then
            Select Case UCase(TypeName(lControl))
                Case "TEXTBOX"
                    lControl.Text = ""
                Case "ARMCOMBOBOX"
'                    Set lControl.SelectedItem = Nothing
                    Call lControl.Clear
                Case "A_CALOCX"
                    lControl.reinit_cal
                Case "CHECKBOX"
                    lControl.Value = vbUnchecked
                Case "ARMCHECKVIEW"
                    lControl.Init
                    
                Case "FRAME", "LABEL", "TOOLBARCONTROL", "PICTUREBOX", "COMMANDBUTTON"
 
                Case "ARMGRID"
                    lControl.ClearGrid
                Case "LISTBOX"
                    lControl.ListIndex = -1
                Case "OPTIONBUTTON"
                    lControl.Value = False
                Case "TABSTRIP", "DRIVELISTBOX", "DIRLISTBOX", "FILELISTBOX", "TOOLBARCONTROL", "LINE"
                
                Case "ARMPICKER"
                    Call lControl.Clear
                
                Case Else
                    Debug.Print "ClearForm " & UCase(TypeName(lControl))
            End Select
        End If
 
        Set lControl = Nothing
    Next
 
   ' mb_internal = False
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ClearForm")
End Sub

' ************************************************************************************
' **************************** DB-ACCESS FUNCTIONS ***********************************
' ************************************************************************************
#If LIVE = 1 Then
Private Sub ExecuteSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1)
#Else
Private Sub ExecuteSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1)
#End If
On Error GoTo ErrHandler
    ' First execute the request
    If Not ao_DB.ExecuteSQL(as_Request) Then
        Call Err.Raise(CompFncFailed, "ao_Db.ExecuteSQL - " & "SQL : " & as_Request, "SQL Error: " & GetDbError(ao_DB))
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.SQLRowsAffected <> al_RowAffectedCount Then
            Call Err.Raise(SQLBadRowAffectedCount, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_DB.SQLRowsAffected)
        End If
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ExecuteSQLSafe")
End Sub

#If LIVE = 1 Then
Private Function OpenSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#Else
Private Function OpenSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#End If
On Error GoTo ErrHandler
    Dim lc_Data As Long
    lc_Data = ao_DB.OpenSQL(as_Request)
    If lc_Data = 0 Then
        Call Err.Raise(CompFncFailed, "ao_Db.OpenSQL - " & "SQL : " & as_Request, "SQL Error: " & GetDbError(ao_DB))
    End If
    
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.RowCount(lc_Data) <> al_RowExpectedCount Then
            Call Err.Raise(SQLBadRowExpectedCount, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_DB.RowCount(lc_Data))
        End If
    End If
    OpenSQLSafe = lc_Data
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".OpenSQLSafe")
End Function

Private Function GetComboKey(ByVal ao_Combo As ArmCombobox) As String
On Error GoTo ErrHandler

    GetComboKey = ""
    If Not (ao_Combo.SelectedItem Is Nothing) Then
        GetComboKey = Trim(CStr(ao_Combo.SelectedItem.Key))
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("GetComboKey")
End Function

Private Function SqlInt(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlInt = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If Trim(CStr(av_Data)) <> "" Then
        SqlInt = CStr(av_Data)
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SqlInt")
End Function

Private Function SqlDbl(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlDbl = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If Trim(CStr(av_Data)) <> "" Then
        SqlDbl = Str(av_Data)
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SqlDbl")
End Function

Private Function SqlDate(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlDate = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If (Trim(CStr(av_Data)) <> "") And (CStr(av_Data) <> "0") Then
        SqlDate = "'" & Format(av_Data, "yyyy-mm-dd") & "'"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SqlDate")
End Function

Private Function SQLStr(ByVal as_str As String, Optional ByVal al_MaxLen As Long = 8000) As String
On Error GoTo ErrHandler
    SQLStr = "'" & Replace(Left(as_str, IIf(Len(as_str) <= al_MaxLen, Len(as_str), al_MaxLen)), "'", "''") & "'"
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SqlStr")
End Function

' safe retieving selected item from combobox
Private Function SQLComboBoxValue(ByRef ao_Combobox As ArmCombobox, Optional ByVal as_DefaultValue As String = "NULL", Optional ByVal ab_KeyTitle As Boolean = True) As String
On Error GoTo ErrHandler
    If IsComboboxSelected(ao_Combobox) Then
        SQLComboBoxValue = "'" & IIf(ab_KeyTitle, ao_Combobox.SelectedItem.Key, ao_Combobox.SelectedItem.DisplayText) & "'"
    Else
        SQLComboBoxValue = as_DefaultValue
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SQLComboBoxValue")
End Function

Private Function SQLOptionButtonValue(ByRef ao_options As Object) As String
On Error GoTo ErrHandler
    SQLOptionButtonValue = ""
    Dim opt_obj As OptionButton
    For Each opt_obj In ao_options
        If opt_obj.Value Then
            SQLOptionButtonValue = opt_obj.Tag
            Exit For
        End If
    Next
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SQLOptionButtonValue")
End Function

Private Function IsComboboxSelected(ByRef as_combo As ArmCombobox) As Boolean
On Error GoTo ErrHandler
    IsComboboxSelected = False
    If Not as_combo.SelectedItem Is Nothing Then
        If Not IsEmpty(as_combo.SelectedItem.Key) Then
            IsComboboxSelected = True
        End If
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".IsComboboxSelected")
End Function

' ************************************************************************************

' ************************************************************************************
' **************************** REDIM FUNCTION ****************************************
' ************************************************************************************
Sub SafeRedimString(ByRef as_Array() As String, al_NumElements As Long)

On Error GoTo ErrHandler

  If al_NumElements = 0 Then
          ReDim as_Array(-1 To -1)
  Else
          'MS REDIMM
          Call SafeRedimPreserve(as_Array, al_NumElements - 1)
  End If
  Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SafeRedimString()")
End Sub

Sub SafeRedim(ByRef av_Array() As Variant, al_NumElements As Long)

On Error GoTo ErrHandler

  If al_NumElements = 0 Then
          ReDim av_Array(-1 To -1)
  Else
          'MS REDIMM
          Call SafeRedimPreserve(av_Array, al_NumElements - 1)
  End If
  Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SafeRedim()")
End Sub
' **************************** REDIM FUNCTION ****************************************

' ************************************************************************************
' ********************** ERROR-HANDLING SUPPORT FUNCTIONS ****************************
' ************************************************************************************
#If LIVE = 1 Then
Private Function GetDbError(ByVal lo_Db As Object) As String
#Else
Private Function GetDbError(ByVal lo_Db As ARMSYSCOMLib.ArmDb) As String
#End If
On Error GoTo ErrHandler
    If IsArray(lo_Db.SQLErrorMessages) Then
        Debug.Assert (IsArray(lo_Db.SQLErrorCodes))
        ' Display errors msgBox
        GetDbError = Join(lo_Db.SQLErrorCodes, ",") & vbCrLf & Join(lo_Db.SQLErrorMessages, vbCrLf)
    Else
        ' ExecuteSQL failed but no error message?
        GetDbError = "Unknown error"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetDbError()")
End Function

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String)
    If Err.Number = QuietException Then Exit Sub
    Dim ll_oldMP As MousePointerConstants
    
    'save mouse pointer
    ll_oldMP = Screen.MousePointer
    Screen.MousePointer = vbDefault
    
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    
    Call LogMessage(App.ProductName & " exception raised. Err.Number:" & Err.Number & ", Err.Source:" & ls_ErrSource & ", Err.Description " & ls_errDescription & ".", "E", False)
    Call MsgBox("Error occured, please contact IT" & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, , "Error message: " & as_Fct)
    
    'restore mouse pointer
    Screen.MousePointer = ll_oldMP
End Sub

Function MsgText(ByVal aID As Long, ByVal aLang As String, ByVal aDefault As String, Optional ByVal aInfo As Variant) As String
On Error GoTo ErrHandler

Const DB_REQ As String = "SELECT message_text FROM error_message WHERE msgid = $id$ AND Language_code = '$lang$'"

    MsgText = ""
    
    Dim lRequest As String
    lRequest = ReplacePlaceHolder(DB_REQ, "$id$", aID)
    lRequest = ReplacePlaceHolder(lRequest, "$lang$", aLang)
    Dim lData As Long
    
    lData = OpenSQLSafe(mo_Db, lRequest)
    
    Dim lBuffer As String
    lBuffer = mo_Db.GetFields(lData, "message_text")
    mo_Db.Close (lData)
    If lBuffer = "" Then lBuffer = aDefault
    
    Dim li_Idx As Integer
    If Not IsMissing(aInfo) Then
        For li_Idx = 0 To UBound(aInfo)
            lBuffer = Replace(lBuffer, aInfo(li_Idx, 0), aInfo(li_Idx, 1), , , vbTextCompare)
        Next li_Idx
    End If
    
    
    MsgText = lBuffer
    Exit Function
ErrHandler:
    mo_Db.Close (lData)
    Call MsgBox("Connection failure accessing message information.")
    MsgText = aDefault
End Function

Private Sub LogMessage(ByVal as_logMsg As String, Optional ByVal as_logType As String = "I", Optional ab_throwException As Boolean = True)
On Error GoTo ErrHandler
Const InsertReq As String = "EXEC A_log_ins $UCODE$, $LOGTYPE$, $MSG$, $APP$"
    Dim ls_req As String
    Dim ll_cursor As Long
    
    ls_req = Replace(InsertReq, "$UCODE$", CStr(ml_U_Code))
    ls_req = Replace(ls_req, "$APP$", SQLStr(C_APPNAME & " " & App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision, 50))
    ls_req = Replace(ls_req, "$MSG$", SQLStr(as_logMsg, 4000))
    ls_req = Replace(ls_req, "$LOGTYPE$", SQLStr(as_logType), 1)
    
    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    Exit Sub
ErrHandler:
    If ab_throwException Then Call ErrorHandler(Extender.Name & ".LogMessage()")
End Sub

' procedure save/restore err object
Private Sub UpdateError(Optional ab_saveError As Boolean = False)
Static ls_ErrDesc As String
Static ls_ErrSource As String
Static ll_errnum As Long
    
    If ab_saveError Then
        ls_ErrDesc = Err.Description
        ls_ErrSource = Err.Source
        ll_errnum = Err.Number
    Else
        Err.Description = ls_ErrDesc
        Err.Source = ls_ErrSource
        Err.Number = ll_errnum
    End If
End Sub

Private Function SendMessage(ByVal as_msg As String, Optional Buttons As VbMsgBoxStyle = vbOKOnly) As VbMsgBoxResult
On Error GoTo ErrHandler
    Call LockScreen(True)
    SendMessage = MsgBox(as_msg, Buttons)
    Call LockScreen(False)
    Exit Function
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage(Extender.Name & ".SendMessage")
End Function

' function return original container
Private Function MoveControlToFront(ByRef ao_ctrl As Object) As Object
On Error GoTo ErrHandler
    Set MoveControlToFront = ao_ctrl.Container
    ao_ctrl.Top = ao_ctrl.Container.Top + ao_ctrl.Top
    ao_ctrl.Left = ao_ctrl.Container.Left + ao_ctrl.Left
    Set ao_ctrl.Container = ao_ctrl.Container.Container
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".MoveControlToFront")
End Function

' recalculate position correctly only in case of one level hierachical change
Private Function MoveControlToFrame(ByRef ao_ctrl As Object, ByRef ao_Frame As VB.Frame) As Object
On Error GoTo ErrHandler
    Set MoveControlToFrame = ao_ctrl.Container
    Set ao_ctrl.Container = ao_Frame
    ao_ctrl.Top = ao_ctrl.Top - ao_Frame.Top
    ao_ctrl.Left = ao_ctrl.Left - ao_Frame.Left
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".MoveControlToFrame")
End Function

' ************************************************************************************
' *************************** INTERNATIONAL FUNCTIONS ********************************
' ************************************************************************************

Private Function GetCodePageFromLanguage(ByRef ao_Armdb As Object, ByVal as_Language As String) As Long
On Error GoTo ErrHandler
Const C_REQ As String = "SELECT Code_Page FROM Language WHERE Language_Code = '$Language_Code$'"
    Dim ls_req As String
    Dim ll_cursor As Long
    Dim ll_codePage As Long
    
    ls_req = ReplacePlaceHolder(C_REQ, "$Language_Code$", as_Language)

    ll_cursor = OpenSQLSafe(ao_Armdb, ls_req)
    Debug.Assert (ll_cursor <> 0)
    
    ll_codePage = CLng(ao_Armdb.GetFields(ll_cursor, "Code_Page"))
    Call ao_Armdb.Close(ll_cursor)
    GetCodePageFromLanguage = ll_codePage
    Exit Function
    
ErrHandler:
    If ll_cursor <> 0 Then Call ao_Armdb.Close(ll_cursor)
    Call ErrorHandler("GetCodePageFromLanguage()")
End Function

'convert code page into charset integer
Private Function GetCharSetFromCodePage(ByVal al_CodePage As Long) As Long

On Error GoTo ErrHandler

    Select Case CStr(al_CodePage)
        Case 932 ' Japanese
            GetCharSetFromCodePage = 128
        Case 936 ' Simplified Chinese
            GetCharSetFromCodePage = 134
        Case 949 ' Korean
            GetCharSetFromCodePage = 129
        Case 950 ' Traditional Chinese
            GetCharSetFromCodePage = 136
        Case 1250 ' Eastern Europe
            GetCharSetFromCodePage = 238
        Case 1251 ' Russian
            GetCharSetFromCodePage = 204
        Case 1252 ' Western European Languages
            GetCharSetFromCodePage = 0
        Case 1253 ' Greek
            GetCharSetFromCodePage = 161
        Case 1254 ' Turkish
            GetCharSetFromCodePage = 162
        Case 1255 ' Hebrew
            GetCharSetFromCodePage = 177
        Case 1256 ' Arabic
            GetCharSetFromCodePage = 178
        Case 1257 ' Baltic
            GetCharSetFromCodePage = 186
        Case Else
            GetCharSetFromCodePage = 0
    End Select
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("GetCharSetFromCodePage()")
End Function

Private Sub ChangeCharset(ByRef ao_Container As Object, Optional ByVal aCodePage As Long)
On Error GoTo ErrHandler
   
    Dim lc_Control As Control
    Dim ll_Charset As Long
    
    On Error Resume Next
    ll_Charset = GetCharSetFromCodePage(aCodePage)
    
    For Each lc_Control In ao_Container
        Select Case UCase(TypeName(lc_Control))
        Case "TABSTRIP", "TEXTBOX", "LABEL", "FRAME", "COMMANDBUTTON", _
              "LISTVIEW", "CHECKBOX", "OPTIONBUTTON", _
              "ARMCHECKVIEW", "ARMTREEVIEW", "ARMGRID", "ARMCOMBOBOX", "ARMCHECKVIEW0"
            lc_Control.Font.Name = "Arial"
            lc_Control.Font.Charset = ll_Charset
        Case "A_SEEK", "A_SRCHTXT"
            lc_Control.Charset = ll_Charset
        End Select
    Next
    
    Exit Sub

ErrHandler:
    Call ErrorHandler(Extender.Name & ".ChangeCharset")
End Sub

Private Function ReplacePlaceholderByGridRow(ByVal as_Request As String, ByRef ao_grid As ArmGrid, ByVal al_Row As Long) As String
On Error GoTo ErrHandler
    Dim ll_Col As Long
    Dim lo_Column As ArmColumn
    
    For ll_Col = 0 To ao_grid.Cols - 1
        Set lo_Column = ao_grid.Columns(ll_Col)
        Select Case lo_Column.FieldType
            Case DBTYPE_DATE
                as_Request = ReplacePlaceHolder(as_Request, "$" & lo_Column.FieldName & "$", SqlDate(lo_Column.GetData(al_Row)))
            Case DBTYPE_STR, DBTYPE_BSTR
                as_Request = ReplacePlaceHolder(as_Request, "$" & lo_Column.FieldName & "$", SQLStr(lo_Column.GetData(al_Row)))
            Case DBTYPE_I4
                as_Request = ReplacePlaceHolder(as_Request, "$" & lo_Column.FieldName & "$", SqlInt(lo_Column.GetData(al_Row)))
            Case DBTYPE_R4, DBTYPE_R8
                as_Request = ReplacePlaceHolder(as_Request, "$" & lo_Column.FieldName & "$", SqlDbl(lo_Column.GetData(al_Row)))
            Case Else
                as_Request = ReplacePlaceHolder(as_Request, "$" & lo_Column.FieldName & "$", lo_Column.GetData(al_Row))
        End Select
    Next

    ReplacePlaceholderByGridRow = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ChangeCharset")
End Function

Private Function ReplacePlaceholderByControlValue(ByVal as_Request As String, ByRef ao_Control As Object) As String
On Error GoTo ErrHandler

Dim lsa_Columns() As String

    If Trim(ao_Control.Tag) = "" Then
        ReplacePlaceholderByControlValue = as_Request
        Exit Function
    End If
    
    Select Case UCase(TypeName(ao_Control))
        Case "ARMCOMBOBOX"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            
            If UBound(lsa_Columns) >= 0 Then
                If GetComboKey(ao_Control) = "" Then
                    as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
                Else
                    as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(GetComboKey(ao_Control)))
                End If
            End If
            If UBound(lsa_Columns) >= 1 Then
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(1) & "$", SQLStr(ao_Control.Text))
            End If
        Case "ARMPICKER"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            
            If UBound(lsa_Columns) >= 0 Then
                If (Trim(CStr(ao_Control.ItemCode)) = "") Or (CStr(ao_Control.ItemCode) = "0") Then
                    as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
                Else
                    as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(Trim(CStr(ao_Control.ItemCode))))
                End If
            End If
            If UBound(lsa_Columns) >= 1 Then
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(1) & "$", SQLStr(Trim(ao_Control.ItemDescription)))
            End If
        Case "CHECKBOX"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            If ao_Control.Value = vbChecked Then
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr("X"))
            Else
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(""))
            End If
        Case "TEXTBOX"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            If UBound(lsa_Columns) > 0 Then
                
                Select Case lsa_Columns(1)
                    Case "Text"
                        as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(ao_Control.Text))
                    Case "Num"
                        If ao_Control.Text = "" Then
                            as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
                        Else
                            Dim ls_number As String
                            ls_number = Replace(Trim(ao_Control.Text), ms_ThousandSeparator, "", , , vbTextCompare)
                            ls_number = Replace(ls_number, ms_DecimalSeparator, ".", , , vbTextCompare)
                            as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", ls_number)
                        End If
                    Case "Date"
                        If Not IsDate(ao_Control.Text) Then
                            as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
                        Else
                            as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SqlDate(CDate(ao_Control.Text)))
                        End If
                End Select
            Else
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(ao_Control.Text))
            End If
        Case "A_CALOCX"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SqlDate(ao_Control.date_dt))
        Case "TABSTRIP"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            If ao_Control.SelectedItem Is Nothing Then
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
            Else
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(ao_Control.SelectedItem.Key))
            End If
    End Select
    ReplacePlaceholderByControlValue = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplacePlaceholderByControlValue")
End Function

Private Function ReplaceRequestByFrameData(ByVal as_Request As String, ByVal ao_Frame As Frame)
On Error GoTo ErrHandler

Dim lo_Control As Control
   
    For Each lo_Control In UserControl.Controls
        If HasContainer(lo_Control, ao_Frame) Then
            as_Request = ReplacePlaceholderByControlValue(as_Request, lo_Control)
        End If
    Next
    ReplaceRequestByFrameData = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplaceRequestByFrameData")
End Function

Private Function EntryIsUsed(ByVal as_req As String) As Boolean
On Error GoTo ErrHandler
    
Dim ls_req As String
Dim ll_cursor As Long
    
    EntryIsUsed = False
    
    ll_cursor = OpenSQLSafe(mo_Db, as_req)
    
    Debug.Assert (ll_cursor <> 0)
    
    If mo_Db.RowCount(ll_cursor) > 0 Then
        EntryIsUsed = True
    End If
    Call mo_Db.Close(ll_cursor)
    ll_cursor = 0
    Exit Function
ErrHandler:
    EntryIsUsed = False
    Call ErrorHandler(Extender.Name & ".EntryIsUsed")
End Function

Public Function GetServerDate() As Date
Const REQ_GET_SERVER_DATE As String = "SELECT GetDate() as ServerDate"
On Error GoTo ErrHandler
Dim ls_req As String
Dim ll_cursor As Long
    
    GetServerDate = 0
    
    ll_cursor = OpenSQLSafe(mo_Db, REQ_GET_SERVER_DATE)
    
    Debug.Assert (ll_cursor <> 0)
    
    If mo_Db.RowCount(ll_cursor) > 0 Then
        GetServerDate = mo_Db.GetFields(ll_cursor, "ServerDate")
    End If
    
    Call mo_Db.Close(ll_cursor)
    ll_cursor = 0
    
    Exit Function
ErrHandler:
    GetServerDate = 0
    Call ErrorHandler(Extender.Name & ".EntryIsUsed")
End Function

'insert values in tables with VDate_Start and VDate_End
Private Function Insert_ValidityManager(ByVal as_ReqIns As String, _
                                        ByRef as_ErrMessage As String, ls_Date As String) As Boolean
On Error GoTo ErrHandler
    
Dim ls_req      As String

    Insert_ValidityManager = False
    as_ErrMessage = ""
    
    'it means that there is no active entry for current user
    'that is why we can just insert new entry into SPA_UserRoles
            
    ls_req = Replace(as_ReqIns, "$VNewDate_Start$", SqlDate(ls_Date), , , vbTextCompare)
    ls_req = Replace(ls_req, "$VNewDate_End$", "NULL", , , vbTextCompare)
    
    Call ExecuteSQLSafe(mo_Db, ls_req, 1)
        
    Insert_ValidityManager = True
    Exit Function
ErrHandler:
    Insert_ValidityManager = False
        
    Call ErrorHandler(Extender.Name & ".Insert_ValidityManager")
End Function

Private Function Delete_ValidityManager(ByVal ad_CurrVDate_Start As String, _
                                        ByVal ad_CurrVDate_End As String, _
                                        ByVal as_ReqDel As String, _
                                        ByVal ab_ReqCheck As Boolean, _
                                        ByRef as_ErrMessage As String) As Boolean
On Error GoTo ErrHandler
    
Dim ls_req As String
Dim ld_OldEndDate   As Date
    
    Delete_ValidityManager = False
    as_ErrMessage = ""
    
    ' common placeholders
    If ad_CurrVDate_Start = "" Then
        'it means that there is no active entry for current user
        ' so there is nothing to delete
    Else
        If ab_ReqCheck = True Or SqlDate(ad_CurrVDate_Start) = SqlDate(ms_ServerDate) Then
            ld_OldEndDate = ms_ServerDate
        Else
            ld_OldEndDate = ms_ServerDate - 1
        End If
        'it means that there is an active entry for current user
        If ad_CurrVDate_End = "" Then
            '1.set current entry to end at OldEndDate
            ls_req = Replace(as_ReqDel, "$VNewDate_End$", SqlDate(ld_OldEndDate), , , vbTextCompare)
            
            Call ExecuteSQLSafe(mo_Db, ls_req, 1)
        Else
            as_ErrMessage = MsgText(8610, ms_Language_Code, "#This configuration will be active from today or tomorrow and you cannot change it again today.")
            Exit Function
        End If
    End If
    
    Delete_ValidityManager = True
    Exit Function
ErrHandler:
    Delete_ValidityManager = False
    
    Call ErrorHandler(Extender.Name & ".Delete_ValidityManager")
End Function

Private Sub ckv_Countries_ItemCheck(ByVal Item As MSComctlLib.ListItem)


    Dim ls_ItemKey As String, ls_ItemDate As String, ls_ItemText As String
    ls_ItemKey = Item.Tag.GetData(0)
    ls_ItemText = Item.Tag.GetData(1)
    ls_ItemDate = Item.Tag.GetData(2)


    If Item.Checked Then
        If Not grd_Active.SearchKey(True, ls_ItemKey) Then
            Dim ls_Text As String, ll_Idx As Long
            ll_Idx = InStrRev(ls_ItemText, " (", , vbTextCompare) - 1
            ls_Text = Left(ls_ItemText, ll_Idx)
            
            Dim ls_Date As String
            If ls_ItemDate = "" Then
                ls_Date = Format(Now, "dd/mm/yyyy")
            Else
                ls_Date = ls_ItemDate 'DateAdd("d", 1, ls_ItemDate)
            End If
            
            Call grd_Active.AddLine(Array(ls_ItemKey, ls_Text, ls_Date, "", "X"))
        Else
                grd_Active.SelectedLine(0, "VDate_End") = ""
        End If
        Exit Sub
    End If

    If Not Item.Checked Then
        
        If Item.Tag.OriginalChecked Then
            If Not grd_Active.SearchKey(True, ls_ItemKey) Then
                Debug.Print "TODO Error"
            End If

            '__if futur rule, we delete
            If DateDiff("d", grd_Active.SelectedLine(0, "VDate_Start"), Now) < 0 Then
                grd_Active.DeleteSelectedLines
                Exit Sub
            End If
            ' Here we have to check if the item was used or not !
            Dim ls_Request As String
            ls_Request = REQ_COUNTRY_IS_USED
            ls_Request = Replace(ls_Request, "$CT_Code$", SQLStr(ls_ItemKey), , , vbTextCompare)
            Dim ld_Date As Date, lb_IsUsed As Boolean
            lb_IsUsed = EntryIsUsed(ls_Request)
            
            
            '__Today but not used
            If DateDiff("d", grd_Active.SelectedLine(0, "VDate_Start"), Now) = 0 And Not lb_IsUsed Then
                grd_Active.DeleteSelectedLines
                Exit Sub
            End If
            
            ld_Date = IIf(lb_IsUsed, Now, Now - 1)
            grd_Active.SelectedLine(0, "VDate_End") = Format(ld_Date, "dd/mm/yyyy")
 
            Exit Sub
        End If
        
        ' New check !
        If grd_Active.SelectedLine(0, "ManualInsert") = "X" Then
            grd_Active.DeleteLine (ls_ItemKey)
        Else
            grd_Active.SelectedLine(0, "VDate_End") = Format(ls_ItemDate, "dd/mm/yyyy")
        End If

    
    End If


End Sub

Private Sub ckv_Countries_ItemSave(ByVal ao_ItemInfo As ArmItemInfo, Saved As Boolean)
Const REQ_GET_DATES As String = "exec SPA_AuthCountries_sel $CT_Code$"
Dim ls_ReqIns           As String
Dim ls_ReqDel           As String
Dim ls_ReqCheck         As String
Dim lb_MarketIsUsedToday   As Boolean
Dim ls_ErrMessage       As String
Dim ll_cursor           As Long
Dim ls_VDateStart       As String
Dim ls_VDateEnd         As String

    Saved = False
                                        
    Dim ls_ItemKey As String, ls_ItemDate As String
    ls_ItemKey = ao_ItemInfo.GetData(0)
    ls_ItemDate = ao_ItemInfo.GetData(2)
    
    ' CHECK CONCURRENCY !!!!!!!!!
    Dim ll_SPACT_ID As Long, ll_SPM_Code As Long
    Dim ls_StartDate As String, ls_EndDate As String
    
    ' ???? Do we put it into the check view ?
    ls_ReqCheck = Item_ReplacePlaceholders(REQ_GET_DATES)
    ls_ReqCheck = Replace(ls_ReqCheck, "$CT_Code$", SQLStr(ao_ItemInfo.GetData(0)), , , vbTextCompare)
    ls_ReqCheck = Item_ReplacePlaceholders(ls_ReqCheck)
    ll_cursor = OpenSQLSafe(mo_Db, ls_ReqCheck)
    ls_StartDate = mo_Db.GetFields(ll_cursor, "VDate_Start")
    ls_EndDate = mo_Db.GetFields(ll_cursor, "VDate_End")
    ll_SPM_Code = mo_Db.GetFields(ll_cursor, "SPM_Code")
    ll_SPACT_ID = mo_Db.GetFields(ll_cursor, "SPACT_ID")
    mo_Db.Close (ll_cursor)
    
    Dim ls_RequestClose As String

    '__CHECKED ITEM
    If ao_ItemInfo.CurrentChecked Then
    
        'Ensure item has not been taken by another admin between init screen and validate
        If (ll_SPM_Code <> 0) Then
            If (CStr(ll_SPM_Code) <> txt_Key.Text) And (DateDiff("d", ls_EndDate, ms_ServerDate) = 0) Then
                ' TODO: Concurrency issue
                Debug.Print " TODO: Concurrency issue"
                Saved = False
            End If
        End If
    
        If Not grd_Active.SearchKey(True, ls_ItemKey) Then
            Saved = False
            Exit Sub
        End If
        
        If grd_Active.SelectedLine(0, "ManualInsert") = "X" Then
            '__It's a completely new link
            If UBound(ma_AuthCountries_ID_LIST) = -1 Then
                Saved = False
            End If
            
            ls_ReqIns = ReplaceCommonPlaceholders(REQ_INSERT_SPA_AUTH_COUNTRIES)
            ls_ReqIns = Replace(ls_ReqIns, "$CT_Code$", SQLStr(ao_ItemInfo.GetData(0)), , , vbTextCompare)
            ls_ReqIns = Replace(ls_ReqIns, "$SPACT_Id$", ma_AuthCountries_ID_LIST(UBound(ma_AuthCountries_ID_LIST) - 1), , , vbTextCompare)
            ls_ReqIns = Item_ReplacePlaceholders(ls_ReqIns)
            ReDim Preserve ma_AuthCountries_ID_LIST(UBound(ma_AuthCountries_ID_LIST) - 1)
            Dim ls_Date As String
            If Len(ls_ItemDate) = 0 Then
                ls_Date = ms_ServerDate
            Else
                'ls_Date = DateAdd("d", 1, ls_ItemDate)
                ls_Date = ls_ItemDate
            End If
            
            If Insert_ValidityManager(ls_ReqIns, ls_ErrMessage, ls_Date) = True Then
                Saved = True
            Else
                ms_ErrMessage = ls_ErrMessage
            End If
        Else
            '__It's a reopen
            '__Do close
            ls_RequestClose = ReplaceCommonPlaceholders(REQ_DELETE_SPA_AUTH_Countries)
            ls_RequestClose = Replace(ls_RequestClose, "$CT_Code$", SQLStr(ls_ItemKey), , , vbTextCompare)
            ls_RequestClose = Item_ReplacePlaceholders(ls_RequestClose)
            ls_RequestClose = Replace(ls_RequestClose, "$VNewDate_End$", "NULL", , , vbTextCompare)
            Call ExecuteSQLSafe(mo_Db, ls_RequestClose, 1)
            Saved = True
        End If
        Exit Sub
    End If
                                        
                                        
    '__UNCHECKED ITEM
    If Not ao_ItemInfo.CurrentChecked Then
        '__Is it used today ?
        Dim ls_ReqUsedToday As String, lb_UsedToday As Boolean
        ls_ReqUsedToday = Item_ReplacePlaceholders(REQ_COUNTRY_IS_USED)
        ls_ReqUsedToday = Replace(ls_ReqUsedToday, "$CT_Code$", SQLStr(ao_ItemInfo.GetData(0)), , , vbTextCompare)
        lb_UsedToday = EntryIsUsed(ls_ReqUsedToday)

        Dim lb_DoClosed As Boolean ' True if we close, False if we delete
        Dim ls_ClosedDate As String

        '__CASE 1: Start_Date < Today
        If DateDiff("d", ls_StartDate, ms_ServerDate) > 0 Then
            '__We closed the old rule
            lb_DoClosed = True
            ls_ClosedDate = IIf(lb_UsedToday, ms_ServerDate, DateAdd("d", -1, ms_ServerDate))
        End If
        
        '__CASE 2: Start_Date = Today
        If DateDiff("d", ls_StartDate, ms_ServerDate) = 0 Then
            If lb_UsedToday Then
                ls_ClosedDate = ms_ServerDate
                lb_DoClosed = True
            Else
                '__We delete the rule
                lb_DoClosed = False
            End If
        End If
        
        '__CASE 3: Start_Date > Today
        If DateDiff("d", ls_StartDate, ms_ServerDate) < 0 Then
            '__We delete the rule
            lb_DoClosed = False
        End If

        If lb_DoClosed Then
            '__Do close
            ls_RequestClose = ReplaceCommonPlaceholders(REQ_DELETE_SPA_AUTH_Countries)
            ls_RequestClose = Replace(ls_RequestClose, "$CT_Code$", SQLStr(ls_ItemKey), , , vbTextCompare)
            ls_RequestClose = Item_ReplacePlaceholders(ls_RequestClose)
            ls_RequestClose = Replace(ls_RequestClose, "$VNewDate_End$", SqlDate(ls_ClosedDate), , , vbTextCompare)
        Else
            '__Do Delete
            ls_RequestClose = REQ_DELETE_SPA_UNUSED_AUTH_COUNTRIES
            ls_RequestClose = Replace(ls_RequestClose, "$SPACT_ID$", ll_SPACT_ID)
        End If
        Call ExecuteSQLSafe(mo_Db, ls_RequestClose, 1)
        Saved = True
        Exit Sub
    End If
                                        
'    Else
'        ms_ErrMessage = MsgText(8610, ms_Language_Code, "#This configuration will be active from today or tomorrow and you cannot change it again today.")
'    End If
    
    Exit Sub
    
ErrHandler:
    Saved = False
    
    If ll_cursor > 0 Then
        mo_Db.Close (ll_cursor)
        ll_cursor = 0
    End If
    
    Call ErrorHandler(Extender.Name & ".ckv_markets_ItemSave")
End Sub

Private Sub tlb_main_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler
    Static DoCheck As Boolean
    
    If DoCheck = True Then Exit Sub
    DoCheck = True
    
    Call LockScreen(True)
    tlb_Main.Enabled = False

    Select Case as_Role
        Case "A"
            Call Run(SPA_Mode.emAdd, Array(""))
        Case "C" 'delete button
            Call Run(SPA_Mode.emDelete, Array(CLng(txt_Key.Text)))
        Case "B" 'goto Update screen
            Call Run(SPA_Mode.emUpdate, Array(CLng(txt_Key.Text)))
        Case "D"
            RaiseEvent OnPrint(Array(CLng(txt_Key.Text)))
        Case "I" 'Refresh update
            Call Item_Cleanup
            If isNumeric(txt_Key.Text) Then
                Call Item_Restore(Array(CLng(txt_Key.Text)))
            Else
                Call Item_Restore(Array(""))
            End If
            
        Case "H" 'validate mode add
            Select Case activeScreenMode
                Case ArmScreenMode.smAdd
                    Call Item_Add
                Case ArmScreenMode.smUpdate
                    Call Item_Update(Array(CLng(txt_Key.Text)))
                Case ArmScreenMode.smDelete
                    Call Item_Delete(Array(CLng(txt_Key.Text)))
                Case Else
                    Debug.Assert (False)
            End Select
        
        Case "Y" 'Goto next item
            Call popScreenMode
            RaiseEvent OnItemNext
            
            If activeScreenMode <> smView Then
                Call pushScreenMode(smView)
            End If

        Case "Z" 'Goto previous item
            Call popScreenMode
            RaiseEvent OnItemPrevious
        
            If activeScreenMode <> smView Then
                Call pushScreenMode(smView)
            End If
        
        Case "T"
            Call Item_Cleanup
            Call Item_Exit
    End Select
    
    tlb_Main.Enabled = True
    
    Call LockScreen(False)
    
    DoCheck = False

    Exit Sub

ErrHandler:
    
    DoCheck = False
    
    tlb_Main.Enabled = True
    Call LockScreen(False)
    
    Select Case Err.Number
    Case 3007
        MsgBox MsgText(3054, ms_Language_Code, "#This data has been updated by another user. Please reload the data and try again."), vbInformation
    
    Case 3008
        MsgBox MsgText(2138, ms_Language_Code, "#The record you try to open has been deleted by an other user. Please refresh the grid."), vbInformation
        Call Item_Exit
    
    Case Else
        Call LogMessage("tlb_Main_action: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
        Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
        End
    End Select

    Exit Sub
End Sub


Private Sub UpdateMainToolbar()
On Error GoTo ErrHandler
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("UpdateMainToolbar")
End Sub

